(* Conversion of the default input language custom interface to the
   uniform one.  We do not constrain the functor with the
   INPUT_LANGUAGE signature here, since we want to use the
   implementation types in the proof system implementation.  These
   details will be hidden in the proof system inteface. *)

functor InputLanguageDefaultFun(structure Interface: INTERFACE
				structure Hash: HASH) =
  struct
    structure Interface = Interface
    structure ParserDefault = ParserDefaultFun(structure Interface = Interface)
    structure Evaluate
        = EvaluateFun(structure ParserDefault = ParserDefault)

    structure Typecheck
	= TypecheckFun(structure Hash = Hash
		       structure Evaluate = Evaluate)

    open SympBug
    open ParserDefault
    open Typecheck
    open Evaluate
    open ParseTreeStruct

    (* Typechecked program, expression, declaration, whatever, which
       is the result of typechecking a ParseTree. *)
    type ProgramObject = ParseTree * (ParseTree -> ParseTree option)
    (* Type or an expression*)
    type ExpressionType = ParseTree
    (* Context for typechecking *)
    type ProgramContext = ParseTree * (ParseTree -> ParseTree option)

    fun ProgramObject2pt(pt, _) = pt

    val (contextKeyword, theoremKeyword, expressionKeyword, typeKeyword) =
	("module", "theorem", "val", "type")

    (* typeCheckProgram is the same as in Typecheck *)
    fun typeCheckProgram options program =
	let val _ = resetTypeCheckStat()
	    val (prog, ff) = Typecheck.typeCheckProgram options program
	    val debug = lazyVerbDebugStr options
	    val _ = debug "common" (fn () => (Conc(Str "\n\nType checked program:\n\n",
						   pt2str prog)))
            val _ = debug "commonDebug" (fn () => (Conc(Str "\n\nType checked program:\n\n",
							pt2strDebug prog)))
            val _ = lazyVerbDebug options "stat" (typeCheckStat2string)
	in 
	    (prog, ff)
	end

    (* FIX the typechecker to initialize `findObject' with the given one in the ProgramContext *)
    fun typeCheckExpr options (context, _) (expr,tp) =
	let val _ = resetTypeCheckStat()
	    val (newE, newTp, findObject) = Typecheck.typeCheckExpr options context (expr,tp)
	in ((newE, findObject): ProgramObject, newTp)
	end handle EvalError str => raise TypeError("[Evaluator] "^str)

    fun typeCheckContext options (context, _) tree = 
	  (resetTypeCheckStat();
	   Typecheck.typeCheckModuleExpr options context tree)

    fun typeCheckTheorem options (context, _) thm =
	  (resetTypeCheckStat();
	   Typecheck.typeCheckTheorem options context thm
	  handle EvalError str => raise TypeError("[Evaluator] "^str))

    (* Equality on parse trees and objects *)
    (* ptEq is the same *)
    fun poEq ((x,_),(y,_)) = ptEq(x,y)
  end
