signature EVALUATE =
  sig
    structure ParserDefault: PARSER_DEFAULT
    type ParseTree = ParserDefault.ParseTreeStruct.ParseTree
    type options = ParserDefault.Interface.Options.options

    exception EvalError of string

    val evaluateExpr: options -> (ParseTree -> ParseTree option) -> ParseTree -> ParseTree
    (* substitute options (new, old, expr)
       Substitute `new' for `old' in `expr' *)
    val substitute: options -> ParseTree * ParseTree * ParseTree -> ParseTree
    
  (* Obsolete, don't use it *)
    (* val evaluateExprTree: Interface.Options.options 
      -> Interface.ParseTreeStruct.ParseTree
      -> Interface.ParseTreeStruct.ParseTree *)
      
  end
