functor ParserAthenaFun(structure Interface: INTERFACE) =
  struct
    open SympBug
    open Str

    structure Interface = Interface
    structure ParseTreeStruct = AthenaParseTreeFun(structure Pos = Pos)

    open Interface
    open Options
    open ParseTreeStruct;

    structure ParseError: PARSE_ERROR =
      struct
	exception ParseError of string 
	val wasError = ref false
      end
    open ParseError

    structure AthenaLrVals =
	AthenaLrValsFun(structure Token = LrParser.Token
		      structure ParseTreeStruct = ParseTreeStruct
		      structure ParseError = ParseError)

    structure AthenaLex =
	AthenaLexFun(structure Tokens = AthenaLrVals.Tokens
		   structure ParseError = ParseError)

    structure AthenaParser =
	AthenaJoin(structure LrParser = LrParser
		 structure ParseTreeStruct = ParseTreeStruct
		 structure ParserData = AthenaLrVals.ParserData
		 structure Lex = AthenaLex)

    (* Similar parser for user input *)

    structure AthenaInputLrVals =
	AthenaInputLrValsFun(structure Token = LrParser.Token
			   structure ParseTreeStruct = ParseTreeStruct
			   structure ParseError = ParseError)

    structure AthenaInputLex =
	AthenaLexFun(structure Tokens = AthenaInputLrVals.Tokens
		   structure ParseError = ParseError)

    structure AthenaInputParser =
	AthenaJoin(structure LrParser = LrParser
		 structure ParseTreeStruct = ParseTreeStruct
		 structure ParserData = AthenaInputLrVals.ParserData
		 structure Lex = AthenaInputLex)

    type result = AthenaLrVals.ParserData.result
    open AthenaLrVals.ParserData

    fun Parse options ins = 
	let val print_error = fn (s,l,c) =>
	    (wasError := true;
	     printOutCommand options
	     ("error",[UIstring "parse",
		       UIstring ((Int.toString l)^"."^(Int.toString c)^", "^s^"\n")]))
	(* Do not use error correction *)
	    val invoke = fn lexstream =>
		(AthenaParser.parse(15,lexstream,print_error,())
		 handle AthenaParser.ParseError => raise Interface.ParseError("Fatal parse error")
		      | ParseError.ParseError str => raise Interface.ParseError str)
	    val lexer = AthenaParser.makeLexer 
		           (fn (i: int) => TextIO.inputLine ins) print_error
	    val (result,_) = (AthenaLex.UserDeclarations.pos := 1;
			      AthenaLex.UserDeclarations.yypos_bol := 0;
			      wasError := false;
			      invoke lexer)
			      
	in result
	end

    (* Parse user input *)
    fun ParseInput options ins =
	let val print_error = fn (s,l,c) =>
	    (wasError := true;
	     printOutCommand options
	     ("error",[UIstring "parse",
		       UIstring ((Int.toString l)^"."^(Int.toString c)^", "^s^"\n")]))
	(* Do not use error correction *)
	    val invoke = fn lexstream => 
		(AthenaInputParser.parse(0,lexstream,print_error,())
		 handle AthenaParser.ParseError => raise Interface.ParseError("Fatal parse error")
		      | ParseError.ParseError str => raise Interface.ParseError str)
	    val lexer = AthenaInputParser.makeLexer 
		           (fn (i: int) => TextIO.inputLine ins) print_error
	    val (result,_) = (AthenaLex.UserDeclarations.pos := 1;
			      AthenaLex.UserDeclarations.yypos_bol := 0;
			      wasError := false;
			      invoke lexer)
			      
	in result
	end


    (* Extracts the directory name from the file name.  Basically,
     * it's all the string upto and including the last `/' or `\'
     * symbol if there is one, and empty otherwise *)

    fun dirname file =
	let fun loop n str = (case String.sub(str,n) of
				  #"/" => String.substring(str,0,n+1)
				| #"\\" =>String.substring(str,0,n+1)
				| _ => if n = 0 then "" else loop (n-1) str)
	in loop ((String.size file)-1) file
	end

    (* Parses and opens includes recursively *)
(*    fun ParseInclude (options: options) file =
	let val ins = (if file = "-" then TextIO.stdIn
		       else TextIO.openIn file)
	             handle _ => raise SympError("Cannot open input file: "^file)
	    val {verbose = verbose, ... } = options
	    val verb = verb options
	    val program = 
		(verb("Parsing "^file^"...");
		 let val program = Parse options (ins) 
		 in program before
		  (if file = "-" then () else TextIO.closeIn ins;
		   if !wasError then
		       raise SympError("\nThere were parse errors in "
				       ^file^". Exiting.")
		   else (verb("Parsing "^file^"...done")))
		 end)
	    fun expand (Protocol(pos,lst)) = Protocol(pos,map expand lst)
	      | expand x = x
	in expand program
	end
*)
  end
