(* Conversion of the default input language custom interface to the
   uniform one.  We do not constrain the functor with the
   INPUT_LANGUAGE signature here, since we want to use the
   implementation types in the proof system implementation.  These
   details will be hidden in the proof system inteface. *)

functor InputLanguageAthenaFun(structure Interface: INTERFACE
			       structure Hash: HASH): INPUT_LANGUAGE =
  struct
    structure Interface = Interface
    structure ParserAthena = ParserAthenaFun(structure Interface = Interface)

    structure Typecheck
	= AthenaTypecheckFun(structure Hash = Hash
			     structure ParseTreeStruct = 
			       ParserAthena.ParseTreeStruct
			     structure Interface = Interface)

    open SympBug
    open ParserAthena
    open Typecheck 
(*    open Evaluate *)
    open ParseTreeStruct

    (* Typechecked program, expression, declaration, whatever, which
       is the result of typechecking a ParseTree. *)
    type ProgramObject = ParseTree
    (* Type or an expression*)
    type ExpressionType = ParseTree
    (* Context for typechecking *)
    type ProgramContext = ParseTree

    fun ParseFile (options: options) file =
	let val _ = verbDebug options "ParseFile" ("\nAthena: Parsing file "^file^"...\n")
	    val ins = (if file = "-" then TextIO.stdIn
		       else TextIO.openIn file)
	           handle _ => raise SympError("Cannot open input file: "^file)
	    val {verbose = verbose, ... } = options
	    val verb = verb options
	    val program = 
		(verb("Parsing "^file^"...");
		 let val program = Parse options (ins) 
		 in program before
		  (if file = "-" then () else TextIO.closeIn ins;
		   if !wasError then
		       raise SympError("\nThere were parse errors in "
				       ^file^". Exiting.")
		   else (verb("Parsing "^file^"...done")))
		 end)
	in
	    program
	end

    val (contextKeyword, theoremKeyword, expressionKeyword, typeKeyword) =
	("protocol", "theorem", "", "")


   fun typeCheckExpr options context (expr,tp) =
     (expr, tp)

(*
    fun typeCheckContext options context tree = 
      typeCheckContext options

    fun typeCheckTheorem options context thm =
      thm
*)
      
    (* Equality on parse trees and objects *)
    (* ptEq is the same *)
    fun ptEq (x,y) = (x = y)
    fun poEq (x,y) = ptEq(x,y) 
  end
