structure Tokens = Tokens
structure ParseError = ParseError
open ParseError

type pos = int
type svalue = Tokens.svalue
type ('a,'b) token = ('a,'b) Tokens.token
type lexresult= (svalue,pos) token
type arg = string * pos * pos -> unit

val pos = ref 1
val yypos_bol = ref 0  (* remember the val. of yypos at the
			  beginning of the current line *)

val eof = fn _ => Tokens.EOF((!pos,0),0,0)

(* This is passed as a parameter to `lex' now *)
(* val error = fn (e,l,c) => (wasError := true;
			   printOut options "parseerror" 
		                ("at "^(Int.toString l)^"."
				 ^(Int.toString c)^": "^e^"\n"))
 *)

fun incLine (x: int ref) =  (x := !x + 1)
fun ripQuotes str = String.extract(str,1,SOME(String.size(str)-2))

fun id2token(s,pos,line) =
    let fun keyword "protocol" = SOME(Tokens.PROTOCOL((pos,line),pos,line))
	  | keyword "role" = SOME(Tokens.ROLE((pos,line),pos,line))
	  | keyword "begin" =  SOME(Tokens.BEGIN((pos,line),pos,line))
	  | keyword "end" =  SOME(Tokens.END((pos,line),pos,line))
	  | keyword "and" =  SOME(Tokens.AND((pos,line),pos,line))
	  | keyword "or" =  SOME(Tokens.OR((pos,line),pos,line))
	  | keyword "implies" =  SOME(Tokens.IMPLIES((pos,line),pos,line))
	  | keyword "not" =  SOME(Tokens.NOT((pos,line),pos,line))
          | keyword "message" = SOME (Tokens.MESSAGE((pos,line),pos,line))
          | keyword "pubkey" = SOME (Tokens.PUBKEY((pos,line),pos,line))
          | keyword "privkey" = SOME (Tokens.PRIVKEY((pos,line),pos,line))
          | keyword "keypair" = SOME (Tokens.KEYPAIR((pos,line),pos,line))
          | keyword "pk" = SOME (Tokens.PUB((pos,line),pos,line))
          | keyword "pub" = SOME (Tokens.PUB((pos,line),pos,line))
          | keyword "pvk" = SOME (Tokens.PRIV((pos,line),pos,line))
          | keyword "priv" = SOME (Tokens.PRIV((pos,line),pos,line)) 
          | keyword "predicate" = SOME (Tokens.PREDICATE((pos,line),pos,line))
          | keyword "theorem" = SOME (Tokens.THEOREM((pos,line),pos,line))
          | keyword "symkey" = SOME (Tokens.SYMKEY((pos,line),pos,line))
          | keyword "nonce" = SOME (Tokens.NONCE((pos,line),pos,line))
          | keyword "freshnonce" = SOME (Tokens.FRESHNONCE((pos,line),pos,line))
          | keyword "send" = SOME (Tokens.SEND((pos,line),pos,line))
          | keyword "receive" = SOME (Tokens.RECEIVE((pos,line),pos,line))
          | keyword "principal" = SOME (Tokens.PRINCIPAL((pos,line),pos,line))
          | keyword "self" = SOME (Tokens.SELF((pos,line),pos,line))
	  | keyword x = NONE
    in
	case keyword(String.map Char.toLower s) of
	    SOME x => x
	  | NONE => Tokens.ID(((pos,line),s),pos,line)
    end
%%

%arg (error);

%header (functor AthenaLexFun(structure Tokens: Athena_TOKENS
			      structure ParseError: PARSE_ERROR));
%s C CC CCC;
alpha=[A-Za-z_];
idchar=[A-Za-z_0-9?\'];
digit=[0-9];
ws = [\ \t\013];
comment = "--".*\n | "#".*\n;

%%

<INITIAL>\n           => (yypos_bol := yypos; incLine pos; continue());
<INITIAL>{ws}+        => (continue());
<INITIAL>{comment}    => (yypos_bol := yypos; incLine pos; continue());
<INITIAL>"(*"         => (YYBEGIN C; continue());
<INITIAL>"*)"         => (error("`*)' without `(*' (you may have exceeded max. depth of comment nesting)",!pos,yypos - !yypos_bol); continue());
<INITIAL>"("          => (Tokens.LP((!pos,yypos - !yypos_bol),!pos,yypos - !yypos_bol));
<INITIAL>")"          => (Tokens.RP((!pos,yypos - !yypos_bol),!pos,yypos - !yypos_bol));
<INITIAL>"["          => (Tokens.LB((!pos,yypos - !yypos_bol),!pos,yypos - !yypos_bol));
<INITIAL>"]"          => (Tokens.RB((!pos,yypos - !yypos_bol),!pos,yypos - !yypos_bol));
<INITIAL>"{"          => (Tokens.LCB((!pos,yypos - !yypos_bol),!pos,yypos - !yypos_bol));
<INITIAL>"}"          => (Tokens.RCB((!pos,yypos - !yypos_bol),!pos,yypos - !yypos_bol));
<INITIAL>"."          => (Tokens.DOT((!pos,yypos - !yypos_bol),!pos,yypos - !yypos_bol));
<INITIAL>"-"          => (Tokens.MINUS((!pos,yypos - !yypos_bol),!pos,yypos - !yypos_bol));
<INITIAL>":="         => (Tokens.EQDEF((!pos,yypos - !yypos_bol),!pos,yypos - !yypos_bol));
<INITIAL>"="          => (Tokens.EQ((!pos,yypos - !yypos_bol),!pos,yypos - !yypos_bol));
<INITIAL>"!="         => (Tokens.NOTEQ((!pos,yypos - !yypos_bol),!pos,yypos - !yypos_bol));
<INITIAL>"->"         => (Tokens.ARROW((!pos,yypos - !yypos_bol),!pos,yypos - !yypos_bol));
<INITIAL>"=>"         => (Tokens.DARROW((!pos,yypos - !yypos_bol),!pos,yypos - !yypos_bol));
<INITIAL>"<->"        => (Tokens.IFF((!pos,yypos - !yypos_bol),!pos,yypos - !yypos_bol));
<INITIAL>"|"          => (Tokens.BAR((!pos,yypos - !yypos_bol),!pos,yypos - !yypos_bol));
<INITIAL>"||"         => (Tokens.DBAR((!pos,yypos - !yypos_bol),!pos,yypos - !yypos_bol));
<INITIAL>"&"          => (Tokens.AND((!pos,yypos - !yypos_bol),!pos,yypos - !yypos_bol));
<INITIAL>"!"          => (Tokens.NOT((!pos,yypos - !yypos_bol),!pos,yypos - !yypos_bol));
<INITIAL>","          => (Tokens.COMMA((!pos,yypos - !yypos_bol),!pos,yypos - !yypos_bol));
<INITIAL>":"          => (Tokens.COLON((!pos,yypos - !yypos_bol),!pos,yypos - !yypos_bol));
<INITIAL>";"          => (Tokens.SEMI((!pos,yypos - !yypos_bol),!pos,yypos - !yypos_bol));
<INITIAL>{alpha}{idchar}* => (id2token(yytext,!pos,yypos - !yypos_bol));
<INITIAL>\"[^\"]*\"   => (Tokens.QUOTE(((!pos,yypos - !yypos_bol),
					ripQuotes yytext),
				       !pos,yypos - !yypos_bol));

<INITIAL>.            => (error ("Illigal character: "^yytext,!pos,yypos - !yypos_bol); continue());

<C>"*)"               => (YYBEGIN INITIAL; continue());
<C>"(*"               => (YYBEGIN CC; continue());
<C>.                  => (continue());

<CC>"*)"              => (YYBEGIN C; continue());
<CC>"(*"              => (YYBEGIN CCC; continue());
<CC>.                 => (continue());

<CCC>"*)"             => (YYBEGIN CC; continue());
<CCC>"(*"             => (error("Exceeded max.  depth of comment nexting",
				!pos,yypos - !yypos_bol); continue());
<CCC>.                => (continue());
