signature ATHENA_TYPECHECK =
  sig

    structure Interface: INTERFACE
    structure ParseTreeStruct: ATHENA_PARSE_TREE

    type ParseTree = ParseTreeStruct.ParseTree

    type options = Interface.Options.options

    (* At this time, a dummy function not used. *)
    val typeCheckExpr: options -> ParseTree -> ParseTree
      -> ParseTree

    (* Return the Program, with all roles and theorems checked and
       (for theorems) expanded fully.  Raises TypeError if there is
       any problem. *)
    val typeCheckProgram: options -> ParseTree -> ParseTree

    (* Return the Protocol, with all roles and theorems checked and
       (for theorems) expanded fully.  Raises TypeError if there is
       any problem. *)
    val typeCheckProtocol: options -> ParseTree -> ParseTree

    (* Return the role "closure" for the given expression, which in
       the case of a role is essentially unchanged. *)
    val typeCheckRoleExpr: options -> ParseTree ->
      (ParseTree * ParseTree list option * ParseTree list)

    (* First parsetree should be a context (a Protocol), second should
       be an ID.  Returns the associated Theorem, if one exists.  
       Otherwise raises TypeError. *)
    val typeCheckTheorem: options -> ParseTree -> ParseTree 
      -> ParseTree

    (* First parsetree should be a context (a Program, here), second should
       be an ID.  Returns the associated Protocol, if one exists.  
       Otherwise raises TypeError. *)
    val typeCheckContext: options -> ParseTree -> ParseTree
      -> ParseTree
  end
