functor AthenaSequentFun(structure Interface: INTERFACE
			 structure Hash: HASH): SEQUENT =
  struct

    open Str
    open Interface

    structure SequentBase =
      struct
	structure InputLanguage =
	    InputLanguageAthenaFun(structure Interface = Interface
				   structure Hash = Hash)
	open InputLanguage

	type SequentHints = unit
	type Sequent = unit
	datatype SequentPart = GammaPart | DeltaPart | AnyPart

	fun formulaInd2str(part, nOpt) =
	    let fun part2str GammaPart = "-"
		  | part2str DeltaPart = "+"
		  | part2str AnyPart = "*"
	    in
		(part2str part)
		^(case nOpt of
		      NONE => ""
		    | SOME n => Int.toString n)
	    end

	fun sequent2str _ = Str "<sequent>"
	fun sequent2string seq = Str2string(sequent2str seq)

	fun hints2string hints = ""
      end

    (* Open them here, before SML figures out their signatures and constrains them *)
    open SequentBase
    open InputLanguage

    (* Some common types and functions *)
    structure SequentCommon = SequentCommonFun(structure Interface = Interface
					       structure SequentBase = SequentBase)

    open SequentCommon

    open SympBug
    open Str
    open ListOps

    type ProofSystemCommandResult = unit

    type ProofSystemCommand = unit

    type Substitution = unit

    type InferenceRuleArgumentSpec =
	  { name: string,
	    Type: InferenceRuleArgumentType }

    type InferenceRule = unit

    fun IRArgSpecName({name=name,...}: InferenceRuleArgumentSpec) = name
    fun IRArgSpecType({Type=tp,...}: InferenceRuleArgumentSpec) = tp

    fun makeSequent context obj = ()
    fun sequentEq(_, _) = false
    fun sequentSubsumes(pair as (_, _)) = sequentEq pair
    fun hintsEq(_, _) = true

    (* Extract sequent part from a UIArg specification *)
    fun UIArg2FormulaIndex(UInumber n) =
	  if n >= 0 then (DeltaPart, SOME n)
	  else (GammaPart, SOME(~n))
      | UIArg2FormulaIndex(UIstring str) =
	  (case String.explode str of
	       [#"*"] => (AnyPart, NONE)
	     | [#"-"] => (GammaPart, NONE)
	     | [#"+"] => (DeltaPart, NONE)
	     | #"*"::digits => 
		   ((case Int.fromString(String.implode digits) of
			 NONE => raise ProverError("Bad formula number: "^str)
		       | SOME n => (AnyPart, SOME n))
			 handle _ => raise ProverError
			     ("Too large formula number: "^str))
	     | #"-"::digits => 
		   ((case Int.fromString(String.implode digits) of
			 NONE => raise ProverError("Bad formula number: "^str)
		       | SOME n => (GammaPart, SOME n))
			 handle _ => raise ProverError
			     ("Too large formula number: "^str))
	     | digits as (_::_) => 
		   ((case Int.fromString(String.implode digits) of
			 NONE => raise ProverError("Bad formula number: "^str)
		       | SOME n => (DeltaPart, SOME n))
			 handle _ => raise ProverError
			     ("Too large formula number: "^str))
	     | _ =>  raise ProverError
			 ("Bad formula number: \""^str^"\""))
      | UIArg2FormulaIndex arg = raise ProverError
	       ("Bad formula number: "^(UIArg2string arg))

    fun FormulaIndex2UIArg part = UIstring(formulaInd2str part)

    fun getRuleName _ = "<rule-name>"
    fun getCommandName _ = "<command-name>"

    fun getRuleArgs _ = []: InferenceRuleArgumentSpec list
    fun getCommandArgs _ = []: InferenceRuleArgumentSpec list

    fun getRuleHelp _ = "<rule help>"
    fun getCommandHelp _ = "<command help>"

    fun checkRuleArgs specs args = NONE: string option

    fun matchRule(seq, context) (rule, args) = NONE: Substitution option

    fun applyRule printFun (seq, context) (rule, args, substOpt) = InferenceRuleFailure
    fun applyCommand printFun (seq, context) (command, args) =
	   NONE: ProofSystemCommandResult option

    fun matchAllRules seq = raise SympBug
	  ("SequentAthena.matchAllRules: sorry, I'm not implemented yet.")

    fun string2hints str = ()

    fun getSequentInfo seq request = "<sequent info>"

end

