functor AthenaProofSystemFun(structure Interface: INTERFACE
			     structure Hash: HASH): PROOF_SYSTEM =
  struct
    structure Interface = Interface
    structure Hash = Hash

    structure Sequent = AthenaSequentFun(structure Interface = Interface
					 structure Hash = Hash)

    open Sequent
    open SequentCommon

    type ProofSystemTactic = unit
    type ProofSystemTacticState = unit

    fun initProofSystem() = ()

    fun findRuleByName name = NONE: InferenceRule option
    fun findCommandByName name = NONE: ProofSystemCommand option
    fun findTacticByName name = NONE: ProofSystemTactic option

    fun applyRule printFun (seq, context) (rule, args, substOpt) = InferenceRuleFailure
    fun applyCommand printFun (seq, context) (command, args) =
	  NONE: ProofSystemCommandResult option

    (* Must return SOME(ruleName, args, newSequentsList, newTacticState) or NONE *)
    fun applyTactic inline printFun (tactic, args, context, stateOpt)
                    (seq, hintsOpt) =
	NONE: (string * (InferenceRuleArgument list)
		    * ((Sequent * (SequentHints option)) list)
		    * (ProofSystemTacticState option)) option

    fun getTacticName tactic = "<tactic name>"
    fun getTacticArgs tactic = []: InferenceRuleArgumentSpec list
    fun getTacticHelp tactic = "<tactic help>"

    fun addNewRule rule = ()
    fun addNewCommand command = ()
    fun addNewTactic tactic = ()
    fun getAllRules() = []: InferenceRule list
    fun getAllCommands() = []: ProofSystemCommand list
    fun getAllTactics() = []: ProofSystemTactic list
  end
