functor AthenaParseTreeFun(structure Pos: POS): ATHENA_PARSE_TREE =
  struct
    open Pos
    open Str
    open SympBug

    exception SympParseInternalError of string

    datatype ParseTree = 
	Protocol of Pos * ParseTree * ParseTree list
      | Program of Pos * ParseTree list
      | Id of Pos * string
      | Role of Pos.Pos * { name: ParseTree,
			    params: ParseTree list option,
			    body: ParseTree }
      | Parameter of Pos.Pos * (ParseTree list) * ParseTree
      | MessageType of Pos.Pos
(*
      | SymKeyType of Pos.Pos
      | PubKeyType of Pos.Pos
      | PrivKeyType of Pos.Pos
      | KeyPairType of Pos.Pos
*)
      | NonceType of Pos.Pos
      | FreshNonceType of Pos.Pos
      | PrincipalType of Pos.Pos
      | SelfType of Pos.Pos
      | Pub of Pos.Pos * ParseTree
      | Priv of Pos.Pos * ParseTree
      | KeyPair of Pos.Pos * (ParseTree * ParseTree)
      | RoleBody of Pos.Pos * ParseTree list
      | Send of Pos.Pos * ParseTree
      | Receive of Pos.Pos * ParseTree
      | Labeled of ParseTree * ParseTree
      | MessageTuple of Pos.Pos * ParseTree list
      | Crypt of Pos.Pos * ParseTree * ParseTree
      | Predicate of Pos.Pos * {name : ParseTree,
				params: ParseTree list option,
				def: ParseTree}
      | Theorem of Pos.Pos * {name : ParseTree,
			      params: ParseTree list option,
			      def: ParseTree}
      | Not of Pos.Pos * ParseTree
      | Or of Pos.Pos * ParseTree * ParseTree
      | And of Pos.Pos * ParseTree * ParseTree
      | Implies of Pos.Pos * ParseTree * ParseTree
      | Atomic of Pos.Pos * ParseTree list
      | FormulaInstance of Pos.Pos * ParseTree * ParseTree list option
      | RoleLabel of Pos.Pos * ParseTree * ParseTree list option * ParseTree
      | RoleStrand of Pos.Pos * ParseTree * ParseTree list option
      | Range of Pos.Pos * ParseTree * ParseTree

    fun pos (Protocol(p,_,_)) = p
      | pos (Program(p,_)) = p
      | pos (Id(p,_)) = p
      | pos (Role(p,_)) = p
      | pos (Parameter(p,_,_)) = p
      | pos (MessageType(p)) = p
(*
      | pos (SymKeyType(p)) = p
      | pos (PubKeyType(p)) = p
      | pos (PrivKeyType(p)) = p
      | pos (KeyPairType(p)) = p
*)
      | pos (NonceType(p)) = p
      | pos (FreshNonceType(p)) = p
      | pos (PrincipalType(p)) = p
      | pos (SelfType(p)) = p
      | pos (Pub(p,_)) = p
      | pos (Priv(p,_)) = p
      | pos (KeyPair(p,_)) = p
      | pos (RoleBody(p,_)) = p
      | pos (Send(p,_)) = p
      | pos (Receive(p,_)) = p
      | pos (Labeled(i,_)) = pos i
      | pos (MessageTuple(p,_)) = p
      | pos (Crypt(p,_,_)) = p
      | pos (Predicate (p,_)) = p
      | pos (Theorem (p,_)) = p
      | pos (Atomic (p, _)) = p
      | pos (Not (p,_)) = p
      | pos (And (p,_,_)) = p
      | pos (Or (p,_,_)) = p
      | pos (Implies (p,_,_)) = p
      | pos (RoleLabel (p,_,_,_)) = p
      | pos (RoleStrand (p,_,_)) = p
      | pos (FormulaInstance (p,_,_)) = p
      | pos (Range (p,_,_)) = p

    fun pos2string (l,c) = (Int.toString l)^"."^(Int.toString c)
      
    fun pa2string [] = "]"
      | pa2string [h] = 
      (pt2string h) ^ "]"
      | pa2string (h::t) =
      (pt2string h) ^ "; " ^ (pa2string t)

    and params2string pa =
      "[" ^ (pa2string pa)

    (* Two pretty-printers.  pt2string does not expand roles/theorems,
       while pt2stringVerbose does.  pt2string calls pt2stringVerbose
       for top-level definitions.  *)  
    and pt2stringVerbose (Protocol (_, name, decls)) =
      "protocol " ^ (pt2string name) ^ " =\nbegin\n\n" ^
      (List.foldr (fn (x, y) => x ^ "\n\n" ^ y) "" 
       (List.map pt2stringVerbose decls))
      ^ "\n\nend"
      | pt2stringVerbose (Program (_, decls)) =
      List.foldr (fn (x, y) => x ^ "\n\n" ^ y) "" (List.map pt2string decls)
      | pt2stringVerbose (Id (_, id)) = id
      | pt2stringVerbose (Role (_, {name=n,params=SOME pa,body=b})) =
      "role " ^ (pt2string n) ^ " " ^ (params2string pa) ^ " =\n" ^ 
      (pt2string b)
      | pt2stringVerbose (Role (_, {name=n,params=NONE,body=b})) =
      "role " ^ (pt2string n) ^ " =\n" ^ (pt2string b)
      | pt2stringVerbose (Parameter (_, l, tp)) = 
      (strlist2str ", " (List.map pt2string l)) ^ ": " ^ (pt2string tp)
      | pt2stringVerbose (NonceType _) = "Nonce"
      | pt2stringVerbose (FreshNonceType _) = "FreshNonce"
      | pt2stringVerbose (PrincipalType _) = "Principal"
      | pt2stringVerbose (SelfType _) = "Self"
      | pt2stringVerbose (MessageType _) = "Message"
      | pt2stringVerbose (RoleBody (_, l)) = "begin\n" ^
      (List.foldr (fn (x, y) => x ^ "\n" ^ y) "")
       (List.map (fn s => "  " ^ s) (List.map pt2string l)) ^ "end"
      | pt2stringVerbose (Labeled (label, act)) = (pt2string label) ^ ": " ^
      (pt2string act)
      | pt2stringVerbose (Send (_, pt)) = "send " ^ (pt2string pt)
      | pt2stringVerbose (Receive (_, pt)) = "receive " ^ (pt2string pt)
      | pt2stringVerbose (Pub (_, pt)) = "(PK " ^ (pt2string pt) ^ ")"
      | pt2stringVerbose (Priv (_, pt)) = "(PVK " ^ (pt2string pt) ^ ")"
      | pt2stringVerbose (Crypt (_, m, k)) = "{" ^ (pt2string m) ^ "} " ^ 
      (pt2string k)
      | pt2stringVerbose (MessageTuple (_, l)) = 
      "(" ^ strlist2str ", " (List.map pt2string l) ^ ")"
      | pt2stringVerbose (Theorem (_, {name=n,params=SOME pa,def=d})) =
      "theorem " ^ (pt2string n) ^ " " ^ (params2string pa) ^ " =\n  " ^
      (pt2string d)
      | pt2stringVerbose (Theorem (_, {name=n,params=NONE,def=d})) =
      "theorem " ^ (pt2string n) ^ " =\n  " ^ (pt2string d)
      | pt2stringVerbose (Predicate (_, {name=n,params=SOME pa,def=d})) =
      "predicate " ^ (pt2string n) ^ " " ^ (params2string pa) ^ " =\n  " ^
      (pt2string d)
      | pt2stringVerbose (Predicate (_, {name=n,params=NONE,def=d})) =
      "predicate " ^ (pt2string n) ^ " =\n  " ^ (pt2string d)
      | pt2stringVerbose (Not (_, pt)) = "not (" ^ (pt2string pt) ^ ")"
      | pt2stringVerbose (Or (_, pt1, pt2)) = "(" ^ (pt2string pt1) ^ 
      ") or (" ^ (pt2string pt2) ^ ")"
      | pt2stringVerbose (And (_, pt1, pt2)) = "(" ^ (pt2string pt1) ^ 
      ") and (" ^ (pt2string pt2) ^ ")"
      | pt2stringVerbose (Implies (_, pt1, pt2)) = "(" ^ (pt2string pt1) ^ 
      ") -> (" ^ (pt2string pt2) ^ ")"
      | pt2stringVerbose (Atomic (_, l)) = "{" ^ (strlist2str ", " 
					   (List.map pt2string l)) ^ "}"
      | pt2stringVerbose (RoleLabel (_, role, SOME opts, label)) =
      (pt2string role) ^ "[" ^ (strlist2str ", " (List.map pt2string opts)) ^ 
      "]." ^ (pt2string label)
      | pt2stringVerbose (RoleLabel (_, role, NONE, label)) =
      (pt2string role) ^ "." ^ (pt2string label)
      | pt2stringVerbose (RoleStrand (_, role, SOME opts)) =
      (pt2string role) ^ "[" ^ (strlist2str ", " (List.map pt2string opts)) ^
      "]"
      | pt2stringVerbose (RoleStrand (_, role, NONE)) =
      (pt2string role)
      | pt2stringVerbose (Range (_, l1, l2)) = (pt2string l1) ^ "-" ^
      (pt2string l2)
      | pt2stringVerbose (FormulaInstance (_, pt, SOME opts)) =
      (pt2string pt) ^ "[" ^ (strlist2str ", " (List.map pt2string opts)) ^
      "]"
      | pt2stringVerbose (FormulaInstance (_, pt, NONE)) =
      (pt2string pt)
      | pt2stringVerbose (KeyPair (_, (k1, k2))) =
      "KeyPair (" ^ (pt2string k1) ^ ", " ^ (pt2string k2) ^ ")"

    and pt2string (Protocol (_, name, decls)) =
      "protocol " ^ (pt2string name) ^ " =\nbegin\n\n" ^
      (List.foldr (fn (x, y) => x ^ "\n\n" ^ y) "" 
       (List.map pt2stringVerbose decls))
      ^ "\n\nend"
      | pt2string (Program (_, decls)) =
      (List.foldr (fn (x, y) => x ^ "\n\n" ^ y) "" 
       (List.map pt2string decls))
      | pt2string (Id (_, id)) = id
      | pt2string (Role (_, {name=n,params=SOME pa,body=b})) =
      (pt2string n)
      | pt2string (Role (_, {name=n,params=NONE,body=b})) =
      (pt2string n)
      | pt2string (Parameter (_, l, tp)) = 
      (strlist2str ", " (List.map pt2string l)) ^ ": " ^ (pt2string tp)
      | pt2string (NonceType _) = "Nonce"
      | pt2string (FreshNonceType _) = "FreshNonce"
      | pt2string (PrincipalType _) = "Principal"
      | pt2string (SelfType _) = "Self"
      | pt2string (MessageType _) = "Message"
      | pt2string (RoleBody (_, l)) = "begin\n" ^
      (List.foldr (fn (x, y) => x ^ "\n" ^ y) "")
       (List.map (fn s => "  " ^ s) (List.map pt2string l)) ^ "end"
      | pt2string (Labeled (label, act)) = (pt2string label) ^ ": " ^
      (pt2string act)
      | pt2string (Send (_, pt)) = "send " ^ (pt2string pt)
      | pt2string (Receive (_, pt)) = "receive " ^ (pt2string pt)
      | pt2string (Pub (_, pt)) = "(PK " ^ (pt2string pt) ^ ")"
      | pt2string (Priv (_, pt)) = "(PVK " ^ (pt2string pt) ^ ")"
      | pt2string (Crypt (_, m, k)) = "{" ^ (pt2string m) ^ "} " ^ 
      (pt2string k)
      | pt2string (MessageTuple (_, l)) = 
      "(" ^ strlist2str ", " (List.map pt2string l) ^ ")"
      | pt2string (Theorem (_, {name=n,params=SOME pa,def=d})) =
      (pt2string n)
      | pt2string (Theorem (_, {name=n,params=NONE,def=d})) =
      (pt2string n)
      | pt2string (Predicate (_, {name=n,params=SOME pa,def=d})) =
      (pt2string n)
      | pt2string (Predicate (_, {name=n,params=NONE,def=d})) =
      (pt2string n)
      | pt2string (Not (_, pt)) = "not (" ^ (pt2string pt) ^ ")"
      | pt2string (Or (_, pt1, pt2)) = "(" ^ (pt2string pt1) ^ ") or (" ^
      (pt2string pt2) ^ ")"
      | pt2string (And (_, pt1, pt2)) = "(" ^ (pt2string pt1) ^ ") and (" ^
      (pt2string pt2) ^ ")"
      | pt2string (Implies (_, pt1, pt2)) = "(" ^ (pt2string pt1) ^ ") -> (" ^
      (pt2string pt2) ^ ")"
      | pt2string (Atomic (_, l)) = "{" ^ (strlist2str ", " 
					   (List.map pt2string l)) ^ "}"
      | pt2string (RoleLabel (_, role, SOME opts, label)) =
      (pt2string role) ^ "[" ^ (strlist2str ", " (List.map pt2string opts)) ^ 
      "]." ^ (pt2string label)
      | pt2string (RoleLabel (_, role, NONE, label)) =
      (pt2string role) ^ "." ^ (pt2string label)
      | pt2string (RoleStrand (_, role, SOME opts)) =
      (pt2string role) ^ "[" ^ (strlist2str ", " (List.map pt2string opts)) ^
      "]"
      | pt2string (RoleStrand (_, role, NONE)) =
      (pt2string role)
      | pt2string (Range (_, l1, l2)) = (pt2string l1) ^ "-" ^
      (pt2string l2)
      | pt2string (FormulaInstance (_, pt, SOME opts)) =
      (pt2string pt) ^ "[" ^ (strlist2str ", " (List.map pt2string opts)) ^
      "]"
      | pt2string (FormulaInstance (_, pt, NONE)) =
      (pt2string pt)
      | pt2string (KeyPair (_, (k1, k2))) =
      "KeyPair (" ^ (pt2string k1) ^ ", " ^ (pt2string k2) ^ ")"

  end
