(* Parse tree type and related signature *)

(* This must be on top level *)
(*  type Pos = int * int *)
    
signature ATHENA_PARSE_TREE =
  sig
    exception SympParseInternalError of string
    exception SympBug of string

    type Str = Str.Str

    datatype ParseTree = 
	Protocol of Pos.Pos * ParseTree * ParseTree list
      | Program of Pos.Pos * ParseTree list
      | Id of Pos.Pos * string
      | Role of Pos.Pos * { name: ParseTree,
			    params: ParseTree list option,
			    body: ParseTree }
      | Parameter of Pos.Pos * (ParseTree list) * ParseTree
      | MessageType of Pos.Pos
(*
      | SymKeyType of Pos.Pos
      | PubKeyType of Pos.Pos
      | PrivKeyType of Pos.Pos
      | KeyPairType of Pos.Pos
*)
      | NonceType of Pos.Pos
      | FreshNonceType of Pos.Pos
      | PrincipalType of Pos.Pos
      | SelfType of Pos.Pos
      | Pub of Pos.Pos * ParseTree
      | Priv of Pos.Pos * ParseTree
      | KeyPair of Pos.Pos * (ParseTree * ParseTree)
      | RoleBody of Pos.Pos * ParseTree list
      | Labeled of ParseTree * ParseTree
      | Send of Pos.Pos * ParseTree
      | Receive of Pos.Pos * ParseTree
      | MessageTuple of Pos.Pos * ParseTree list
      | Crypt of Pos.Pos * ParseTree * ParseTree
      | Predicate of Pos.Pos * {name : ParseTree,
				params: ParseTree list option,
				def: ParseTree}
      | Theorem of Pos.Pos * {name : ParseTree,
			      params: ParseTree list option,
			      def: ParseTree}
      | Not of Pos.Pos * ParseTree
      | Or of Pos.Pos * ParseTree * ParseTree
      | And of Pos.Pos * ParseTree * ParseTree
      | Implies of Pos.Pos * ParseTree * ParseTree
      | Atomic of Pos.Pos * ParseTree list
      | FormulaInstance of Pos.Pos * ParseTree * ParseTree list option
      | RoleLabel of Pos.Pos * ParseTree * ParseTree list option * ParseTree
      | RoleStrand of Pos.Pos * ParseTree * ParseTree list option
      | Range of Pos.Pos * ParseTree * ParseTree

    val pos: ParseTree -> Pos.Pos
    val pos2string : Pos.Pos -> string

    (* Two pretty-printers.  pt2string does not expand roles/theorems,
       while pt2stringVerbose does.  pt2string calls pt2stringVerbose
       for top-level definitions.  *)
    val pt2string : ParseTree -> string
    val pt2stringVerbose : ParseTree -> string

  end
