#ifndef _stack_h_INCLUDED
#define _stack_h_INCLUDED

#include "config.h"

/*------------------------------------------------------------------------*/

typedef struct Stack_ * Stack;

/*------------------------------------------------------------------------*/

struct Stack_
{
  void ** bottom, ** top, ** sp;
};

/*------------------------------------------------------------------------*/

extern Stack new_Stack();
extern void free_Stack(Stack);
extern void resize_Stack(Stack);
extern void exit_Stack();

#define is_mt_Stack(stack) ((stack) -> bottom == (stack) -> sp)
#define is_full_Stack(stack) ((stack) -> top == (stack) -> sp)

/*------------------------------------------------------------------------*/
#ifdef DEBUG
/*------------------------------------------------------------------------*/

extern void * pop(Stack);
extern void push(Stack, void*);

/*------------------------------------------------------------------------*/
#else /* DEBUG */
/*------------------------------------------------------------------------*/

#define pop(stack) (* -- (stack) -> sp)
#define push(stack, elem)						\
do									\
  {									\
    if(is_full_Stack(stack)) resize_Stack(stack);			\
    *(stack) -> sp ++ = ((void*)(elem));				\
  }									\
while(0)

/*------------------------------------------------------------------------*/
#endif /* DEBUG */
/*------------------------------------------------------------------------*/

#endif
