#include <stdio.h>

#include "assign.h"
#include "config.h"
#include "ctl.h"
#include "list.h"
#include "pp.h"
#include "prop.h"
#include "var.h"
#include "util.h"

/*------------------------------------------------------------------------*/

extern CTL init, trans, spec, invar;
extern List fairness;
extern int flatten_flag;

/*------------------------------------------------------------------------*/

static void print_smv_var_decl(Variable v)
{
  Assignment a;

  if(v -> is_in_COI)
    {
      a = v -> assignment;

      if(!a || (!a -> define && !a -> defines))
	{
	  if(v -> size > 1)
	    {
	      if(flatten_flag)
		{
		  printf("  %s : array 0..%u of boolean;\n",
		    v -> name, v -> size - 1);
		}
	      else
		{
		  printf("  %s : 0..%u;\n",
		    v -> name, pow2(v -> size) - 1);
		}
	    }
	  else printf("  %s : boolean;\n", v -> name);
	}
    }
}

/*------------------------------------------------------------------------*/

static void print_smv_vars()
{
  /* TODO to get a better initial variable ordering we should print the
   * variable in DFS through the transition relation or something similar.
   */
  forall_Variable(print_smv_var_decl);
}


/*------------------------------------------------------------------------*/

static void print_smv_CTL(CTL f)
{
  _print_pp_CTL("", f, SMV_PP_Format, 0, 2, 0);
}

/*------------------------------------------------------------------------*/

static void print_smv_fairness(void * f)
{
  CTL g;
  
  g = (CTL) f;
  printf("\nFAIRNESS\n\n");
  print_smv_CTL(g);
}

/*------------------------------------------------------------------------*/

void print_smv()
{
  assert(init -> is_propositional);
  assert(trans -> is_propositional);
  assert(invar -> is_propositional);

  add_invar();

  start_verbose("generating SMV model");
  printf("MODULE main\n\nVAR\n\n");
  print_smv_vars();

  if(num_init_assignments + num_next_assignments > 0)
    {
      printf("\nASSIGN\n\n");
      print_pp_next_init_assignments(SMV_PP_Format);
    }

  if(!is_true_CTL(init))
    {
      printf("\nINIT\n\n");
      print_smv_CTL(init);
    }

  if(!is_true_CTL(trans))
    {
      printf("\nTRANS\n\n");
      print_smv_CTL(trans);
    }
  
  if(num_define_assignments)
    {
      printf("\nDEFINE\n\n");
      print_pp_define_assignments(SMV_PP_Format);
    }

  if(!is_true_CTL(invar))
    {
      fatal(POSITION, "can not print INVAR specification for SMV\n");
    }

  if(fairness)
    {
      forall_List(fairness, print_smv_fairness);
    }

  if(!is_true_CTL(spec))
    {
      printf("\nSPEC\n\n");
      print_smv_CTL(spec);
    }
  
  end_verbose("generated SMV model");
}
