%{
#include <stdio.h>
#include <strings.h>

#include "config.h"
#include "var.h"
#include "ctl.h"
#include "y.tab.h"

extern int yyerror(char *);

%}

%%

"/*"		{
		  int c;

		  for(;;)
		    {
		      while((c = input()) != '*' && c != EOF)
			;

		      if(c == '*')
                        {
			  while((c = input()) == '*')
                            ;

			  if( c == '/' ) break;
                        }

		      if (c == EOF)
                        {
			  yyerror("EOF in comment");
			  break;
                        }
                    }
                }

"//".*          ;
"--".*          ;

[ \t\n]+	;

"INIT"		return INIT_Token;
"TRANS"		return TRANS_Token;
"SPEC"		return SPEC_Token;
"INVAR"		return INVAR_Token;
"VAR"		return VAR_Token;
"ASSIGN"	return ASSIGN_Token;
"DEFINE"	return DEFINE_Token;
"FAIRNESS"	return FAIRNESS_Token;
"MODULE"	return MODULE_Token;

"AG"		return AG_Token;
"AF"		return AF_Token;
"AX"		return AX_Token;
"next"		return NEXT_Token;
"init"		return init_Token;
"inc"		return INC_Token;
"dec"		return DEC_Token;
"add"		return ADD_Token;
"sub"		return SUB_Token;
"case"		return CASE_Token;
"esac"		return ESAC_Token;
"switch"	return SWITCH_Token;
"array"		return ARRAY_Token;
"of"		return OF_Token;
"boolean"	return BOOLEAN_Token;
".."		return DOTDOT_Token;

[A-Za-z][A-Za-z0-9_-]*	{
                  yylval.str = strcpy((char*)malloc(strlen(yytext)+1),yytext);
		  return STRING_Token;
		}
[0-9][0-9]*	{
	 	  yylval.number = atoi(yytext);
		  return NUMBER_Token;
		}

"~"		return NOT_Token;
"!"		return NOT_Token;
"+"		return PLUS_Token;
"#"		return OR_Token;
"|"		return OR_Token;
"&"		return AND_Token;
"->"		return IMPLIES_Token;
"<->"		return EQUIV_Token;
"="		return EQUAL_Token;
"!="		return NOTEQUAL_Token;
":="		return BECOMES_Token;

.		return yytext[0];

%%

int yywrap() { return 1; }
