#include "config.h"
#include "prop.h"
#include "pp.h"
#include "util.h"

/*------------------------------------------------------------------------*/

extern int cnf_flag, formula_flag;

/*------------------------------------------------------------------------*/

void print_prove()
{
  CTL f, tmp;

  start_verbose("generating PROVER formula");

  f = gen_prop();

  if(cnf_flag)
    {
      tmp = cnf(f);
      free_CTL(f);
      f = tmp;
    }
  else
  if(!formula_flag)
    {
      tmp = gen_defines(f);
      free_CTL(f);
      f = tmp;
    }

  _print_pp_CTL("", f, PROVE_PP_Format, 0, 0, 0);
  free_CTL(f);

  end_verbose("generated PROVER formula");
}
