#include <stdlib.h>
#include "list.h"

/*------------------------------------------------------------------------*/

List cons(void * d, List l)
{
  List res;

  res = (List) malloc(sizeof(struct List_));
  res -> head = d;
  res -> tail = l;

  return res;
}

/*------------------------------------------------------------------------*/

void forall_List(List l, void(*f)(void*))
{
  List p;

  for(p = l; p; p = cdr(p)) f(p -> head);
}

/*------------------------------------------------------------------------*/

void free_List(List l)
{
  List p, tmp;

  for(p = l; p; p = tmp)
    {
      tmp = cdr(p);
      free(p);
    }
}

/*------------------------------------------------------------------------*/

List reverse_List(List l)
{
  List p, res;

  for(res = 0, p = l; p; p = cdr(p)) res = cons(car(p), res);

  return res;
}

/*------------------------------------------------------------------------*/

unsigned length_List(List l)
{
  unsigned res;
  List p;

  for(res = 0, p = l; p; p = cdr(p))
    res++;

  return res;
} 

/*------------------------------------------------------------------------*/
#ifdef DEBUG
/*------------------------------------------------------------------------*/

void * car(List l)
{
  void * res;

  res = l -> head;

  return res;
}

/*------------------------------------------------------------------------*/

List cdr(List l)
{
  List res;

  res = l -> tail;

  return res;
}

/*------------------------------------------------------------------------*/
#endif
/*------------------------------------------------------------------------*/
