#include <stdlib.h>

#include "idx.h"
#include "util.h"

/*------------------------------------------------------------------------*/

extern int verbose;

/*------------------------------------------------------------------------*/

static Idx * indices = 0;
static unsigned size_indices, num_indices, visited_indices, searches_indices;
static unsigned resize_indices;

/*------------------------------------------------------------------------*/

static unsigned hash_Idx(Idx str, unsigned idx)
{
  unsigned res;

  res = ((unsigned) str) * 49999;
  res = (res + idx) * 9973;

  return res;
}

/*------------------------------------------------------------------------*/

static int is_equal_Idx(Idx a, Idx b, unsigned idx)
{
  int res;

  res = (a -> prev == b && a -> idx == idx);

  return res;
}

/*------------------------------------------------------------------------*/

static void resize_Idx()
{
  unsigned old_size, i, h;
  Idx * old_indices, p, tmp;

  resize_indices++;

  old_size = size_indices;
  old_indices = indices;

  size_indices = next_size(num_indices);
  indices = (Idx*) calloc(sizeof(Idx), size_indices);

  for(i = 0; i < old_size; i++)
    for(p = old_indices[i]; p; p = tmp)
      {
        tmp = p -> next;
	h = hash_Idx(p -> prev, p -> idx) % size_indices;
	p -> next = indices[h];
	indices[h] = p;
      }
  
  free(old_indices);
}

/*------------------------------------------------------------------------*/

Idx new_Idx(Idx a, unsigned idx)
{
  Idx * p, res;
  unsigned h;

  searches_indices++;
  if(num_indices >= 4 * size_indices) resize_Idx();

  h = hash_Idx(a, idx) % size_indices;
  for(p = &indices[h]; *p && !is_equal_Idx(*p, a, idx); p = &(*p) -> next)
    visited_indices++;
  
  if(!*p)
    {
      res = (Idx) malloc(sizeof(struct Idx_));
      res -> idx = idx;
      if(idx == 0 && a) res -> num = a -> num;
      else res -> num = num_indices++;
      res -> prev = a;
      res -> next = 0;
      *p = res;
    }

  res = *p;

  return res;
}

/*------------------------------------------------------------------------*/

void init_Idx(unsigned bound)
{
  unsigned i;

  size_indices = next_size(100);
  indices = (Idx*) calloc(sizeof(Idx), size_indices);

  num_indices = 0;
  visited_indices = 0;
  searches_indices = 0;
  resize_indices = 0;

  for(i = 0; i <= bound; i++) (void) new_Idx(0, i);
}

/*------------------------------------------------------------------------*/

void exit_Idx()
{
  unsigned i;
  Idx p, tmp;
  double avg;

  for(i = 0; i < size_indices; i++)
    for(p = indices[i]; p; p = tmp)
      {
        tmp = p -> next;
	free(p);
      }
  
  free(indices);
  indices = 0;

  if(verbose)
    {
      if(searches_indices)
	{
	  avg = ((double)visited_indices) / ((double)searches_indices);
	  print_verbose("indices: num %u, size %u, avg %.2f\n",
	    num_indices, size_indices, avg);
	}
      else
	{
	  print_verbose("indices: num %u, size %u\n",
	    num_indices, size_indices);
	}
    }
}
