#include <stdio.h>
#include <stdlib.h>

static void usage()
{
  fprintf(stderr, "*** usage:  genpermute [-r <register> <register>] <num>\n");
}

static int log2(int e)
{
  if(e < 0x2)        return 1;
  if(e < 0x4)        return 2;
  if(e < 0x8)        return 3;
  if(e < 0x10)       return 4;
  if(e < 0x20)       return 5;
  if(e < 0x40)       return 6;
  if(e < 0x80)       return 7;
  if(e < 0x100)      return 8;
  if(e < 0x200)      return 9;
  if(e < 0x400)      return 10;
  if(e < 0x800)      return 11;
  if(e < 0x1000)     return 12;
  if(e < 0x2000)     return 13;
  if(e < 0x4000)     return 14;
  if(e < 0x8000)     return 15;
  if(e < 0x10000)    return 16;
  if(e < 0x20000)    return 17;
  if(e < 0x40000)    return 18;
  if(e < 0x80000)    return 19;
  if(e < 0x100000)   return 20;
  if(e < 0x200000)   return 21;
  if(e < 0x400000)   return 22;
  if(e < 0x800000)   return 23;
  if(e < 0x1000000)  return 24;
  if(e < 0x2000000)  return 25;
  if(e < 0x4000000)  return 26;
  if(e < 0x8000000)  return 27;
  if(e < 0x10000000) return 28;
  if(e < 0x20000000) return 29;
  if(e < 0x40000000) return 30;
  if(e < 0x80000000) return 31;
  return 32;
}

static int exp2(int p)
{
  int res, i;

  for(res = 1, i = 0; i < p; i++)
    res *= 2;
  
  return res;
}

int main(int argc, char ** argv)
{
  int i, j, n, l, k, r, s;

  n = r = s = -1;

  for(i = 1; i < argc; i++)
    {
      if('0' <= argv[i][0] && argv[i][0] <= '9')
        {
	  if(n < 0) n = (unsigned) atoi(argv[i]);
	  else
	    {
	      fprintf(stderr, "*** number of registers specified twice\n");
	      usage();
	      exit(1);
	    }
	}
      else
      if(strcmp(argv[i], "-r") == 0)
        {
	  if(r < 0)
	    {
	      if(i + 2 >= argc)
	        {
		  fprintf(stderr, "*** arguments to `-r' is missing\n");
		  usage();
		  exit(1);
		}
	      else
	        {
		  r = atoi(argv[++i]);
		  s = atoi(argv[++i]);
		  if(r == s)
		    {
		      fprintf(stderr, "*** arguments to `-r' are the same\n");
		      usage();
		      exit(1);
		    }
		}
	    }
	  else
	    {
	      fprintf(stderr, "*** `-r' option given twice\n");
	      usage();
	      exit(1);
	    }
	}
    }
  
  if(n < 0)
    {
      fprintf(stderr, "*** number of registers not specified\n");
      usage();
      exit(1);
    }
  
  if(r != -1)
    {
      if(r < -1 || r >= n || s < -1 || s >= n)
	{
	  fprintf(stderr, "*** arguments of `-r' must be in [0,%d]\n", n-1);
	  exit(1);
	}
    }

  l = log2(n); 
  k = log2(n - 1);

  fprintf(stderr, "[genpermute] n = %d, l = %d, k = %d", n, l, k);
  if(r >= 0) fprintf(stderr, ", r = %d\n", r);
  else fprintf(stderr, "\n");

  printf("VAR\n\n");

  printf("  o[%d]\n", k);
  printf("  c[%d]\n", l);
  for(i = 0; i < n; i++)
    printf("  r%d[%d]\n", i, l);
  
  printf("\n");
  printf("ASSIGN\n\n");

  printf("  init(c) := 1;\n");
  printf("  next(c) :=\n");
  printf("    case\n");
  printf("      c = %d : 0;\n", n);
  printf("      1 : inc(c);\n");
  printf("    esac;\n");
  printf("\n");

  for(i = 0; i < n; i++)
    {
      printf("  init(r%d) := 0;\n", i);
      printf("  next(r%d) :=\n", i);
      printf("    case\n");
      printf("      c != 0 & o = %d & r%d = 0 : c;\n", i, i);
      printf("      1 : r%d;\n", i);
      printf("    esac;\n\n");
    }
  
  if(exp2(k) > n)
    {
      printf("INVAR\n\n");
      for(i = 0; i < n - 1; i++)
	printf("  o = %d\n  |\n", i);
      
      printf("  o = %d\n\n", n - 1);
    }
  
  printf("INVAR\n\n");
  printf("  c = 0\n  |\n");
  for(i = 0; i < n - 1; i++)
    printf("  (o = %d -> r%d = 0)\n  &\n", i, i);

  printf("  (o = %d -> r%d = 0)\n\n", n - 1, n - 1);
  
  printf("DEFINE\n\n");

#if 0
  printf("  all_different :=\n");
  printf("    case\n");
  for(i = 0; i < n - 1; i++)
    for(j = i+1; j < n; j++)
      printf("      r%d = r%d : 0;\n", i, j);
  printf("      1 : 1;\n");
  printf("    esac;\n\n");
#else
  printf("  all_different :=\n");
  printf("    case\n");
  for(i = 0; i < n - 1; i++)
    for(j = i+1; j < n; j++)
      {
	printf("      r%d = r%d", i, j);
	if(i == n -2 && j == n - 1) printf(" : 0;\n");
	else printf(" |\n");
      }
  printf("      1 : 1;\n");
  printf("    esac;\n\n");
#endif
  
  printf("SPEC\n\n");

  if(r >= 0)
    {
      printf("  AG (c = 0 -> r%d != r%d)\n", r, s);
    }
  else printf("  AG (c = 0 -> all_different)\n");

  exit(0);
  return 0;
}
