#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <time.h>


static void usage()
{
  fprintf(stderr,
    "*** usage:  genbarral [<options>] <length> [<width>]\n"
    "\n"
    "where <options> is a sequence of the following optionts:\n"
    "\n"
    "  -ord\n"
    "  -s <shift>\n"
    "  -liveness\n"
    "  -random\n"
    "  -permute\n"
    "  -bug\n"
    "  -d <dist>\n");
}

int main(int argc, char ** argv)
{
  int i, j, l, w, b, tmp, permute, liveness, dist, shift, random, bug, ord;
  unsigned bug_pos;

  l = -1;
  w = -1;
  dist = -1;
  shift = -1;

  permute = 0;
  liveness = 0;
  random = 0;
  bug = 0;
  ord = 0;

  for(i = 1; i < argc; i++)
    {
      if('0' <= argv[i][0] && argv[i][0] <= '9')
        {
	  if(l == -1)
	    {
	      l = atoi(argv[i]);
	      if(l < 2)
	        {
		  fprintf(stderr, "*** length must greater 1\n");
		  exit(1);
		}
	    }
	  else
	  if(w == -1)
	    {
	      w = atoi(argv[i]);
	      if(w == 0)
	        {
		  fprintf(stderr, "*** width must greater zero\n");
		  exit(1);
		}
	    }
	}
      else
      if(strcmp(argv[i], "-ord") == 0)
        {
	  ord = 1;
	}
      else
      if(strcmp(argv[i], "-d") == 0)
        {
	  if(dist != -1)
	    {
	      fprintf(stderr, "*** `-d' specified twice\n");
	      exit(1);
	    }

	  if(i + 1 >= argc)
	    {
	      fprintf(stderr, "*** argument to `-d' is missing\n");
	      exit(1);
	    } 
	  
	  dist = atoi(argv[++i]);
	}
      else
      if(strcmp(argv[i], "-s") == 0)
        {
	  if(shift != -1)
	    {
	      fprintf(stderr, "*** `-s' specified twice\n");
	      exit(1);
	    }
	  
	  if(i + 1 >= argc)
	    {
	      fprintf(stderr, "*** argument to `-s' is missing\n");
	      exit(1);
	    }
	  
	  shift = atoi(argv[++i]);
	}
      else
      if(strcmp(argv[i], "-permute") == 0)
        {
	  permute = 1;
	}
      else
      if(strcmp(argv[i], "-liveness") == 0)
        {
	  liveness = 1;
	}
      else
      if(strcmp(argv[i], "-random") == 0)
        {
	  random = 1;
	}
      else
      if(strcmp(argv[i], "-bug") == 0)
        {
	  bug = 1;
	}
      else
        {
	  fprintf(stderr, "*** unknown command line option `%s'\n", argv[i]);
	  usage();
	  exit(1);
	}
    }
  
  if(l == -1)
    {
      fprintf(stderr, "*** length not specified\n");
      usage();
      exit(1);
    }
  
  for(tmp = 1, b = 0; tmp < l; tmp *= 2, b++)
    ;
  
  if(w == -1) w = b;
  else
  if(w < b)
    {
      fprintf(stderr, "*** for length %d the width must be at least %d\n",
        l, b);
      exit(1);
    }
  
  if(shift == -1) shift = 1;
  
  if(dist != -1 && !liveness)
    {
      fprintf(stderr,
        "*** `-d' can only be used together with `-liveness'\n");
      exit(1);
    }
  
  if(bug)
    {
      srand((unsigned) time(0));
      bug_pos = ((unsigned) rand()) % l;
    }
  
  if(ord)
    {
      for(j = 0; j < w; j++)
	for(i = 0; i < l; i++)
	  printf("b%d[%d]\nr%d[%d]\n", i, j, i, j);
      exit(0);
    }

  printf("VAR\n\n");

  for(i = 0; i < l; i++)
    {
      printf("  b%d[%d]\n", i, w);
      printf("  r%d[%d]\n", i, w);
    }

  printf("\n");

  printf("ASSIGN\n\n");

  for(i = 0; i < l; i++)
    {
      printf("  init(b%d) := r%d;\n", i, i);

      j = (bug && bug_pos == i) ? 1 : 0;

      if(random)
        {
	  printf("  next(b%d) :=\n", i);
	  printf("    case\n");
	  printf("      oracle : b%d;\n", (i + shift + j) % l);
	  printf("      1 : b%d;\n", (i + (l - shift)) % l);
	  printf("    esac;\n\n");
	}
      else printf("  next(b%d) := b%d;\n\n", i, (i + (l - shift) + j) % l);
    }

  for(i = 0; i < l; i++) printf("  next(r%d) := r%d;\n\n", i, i);

  if(permute)
    {
      fprintf(stderr, "*** -permute not implemented\n");
      exit(1);

      printf("DEFINE\n\n");

      printf("  all_different :=\n");
      printf("    case\n");
      for(i = 0; i < l - 1; i++)
        for(j = i+1; j < l; j++)
	  {
	    printf("b");
	  }
      printf("    esac;\n\n");

      printf("INIT\n\n");

      printf("  all_different\n\n");

      printf("SPEC\n\n");
      printf("  AG all_different\n");
    }
  else
    {
      printf("DEFINE\n\n");

      printf("  invar :=\n");
      printf("    case\n");
      for(i = 0; i < l; i++)
	for(j = 0; j < l; j++)
	  {
	    printf("      (b%d = r%d -> b%d = r%d)\n",
	      i, j, (i + 1) % l, (j + 1) % l);
	    if(i == l - 1 && j == l - 1) printf("        : 1;\n");
	    else printf("      &\n");
	  }

      printf("      1 : 0;\n");
      printf("    esac;\n\n");

      printf("INIT\n\n  invar\n\n");
      
      if(liveness)
        {
	  printf("SPEC\n\n  AF b0 = r%d\n", dist % l);
	}
      else printf("SPEC\n\n  AG invar\n\n");
    }

  exit(0);
  return 0;
}
