#ifndef _assign_h_INCLUDED
#define _assign_h_INCLUDED

#include "ctl.h"
#include "var.h"

/*------------------------------------------------------------------------*/

typedef enum Assignment_Type_ Assignment_Type;

enum Assignment_Type_
{
  INIT_Assignment,
  NEXT_Assignment,
  DEFINE_Assignment
};

/*------------------------------------------------------------------------*/

typedef struct Assignment_ * Assignment;

struct Assignment_
{
  Variable variable;
  unsigned idx;
  CTL init, next, define;
  CTL * inits, * nexts, * defines;
  Assignment prev_chronological, next_chronological;
};

/*------------------------------------------------------------------------*/

extern void init_Assignment();
extern void exit_Assignment();
extern Assignment find_Assignment(Variable);
extern void insert_Assignment(Assignment_Type, Variable, unsigned, CTL);
extern void free_Assignment();
extern void forall_Assignment(void(*)(Assignment));
extern void remove_if_mt_Assignment(Assignment);

/*------------------------------------------------------------------------*/

extern void gen_assignments();
extern void move_defines_to_INVAR();

/*------------------------------------------------------------------------*/

extern unsigned num_init_assignments;
extern unsigned num_next_assignments;
extern unsigned num_define_assignments;
extern int bitwise_assignment;
extern unsigned num_not_flattened_assignments(Assignment_Type);

/*------------------------------------------------------------------------*/

extern void _end_changing(
  const char * section,
  double size_before, double size_after,
  double nodes_before, double nodes_after);

extern void start_changing();
extern void end_changing();

#endif
