#ifndef _varset_h_INCLUDED
#define _varset_h_INCLUDED

typedef struct VarSet_ * VarSet;

/*------------------------------------------------------------------------*/

#include "var.h"

/*------------------------------------------------------------------------*/

struct VarSet_
{
  Variable variable;
  unsigned idx, ref;
  VarSet child, next;
};

/*------------------------------------------------------------------------*/

extern void init_VarSet();
extern void exit_VarSet();

extern VarSet mt_VarSet();
extern void free_VarSet(VarSet);
extern VarSet copy_VarSet();

extern VarSet add_VarSet(VarSet, Variable, unsigned);
extern VarSet join_VarSet(VarSet, VarSet);
extern int contains_VarSet(VarSet, Variable, unsigned);
extern int intersects_VarSet(VarSet, VarSet);
extern int subset_VarSet(VarSet, VarSet);
extern void print_VarSet(VarSet);
extern unsigned size_VarSet(VarSet);

#endif
