#ifndef _var_h_INCLUDED
#define _var_h_INCLUDED

typedef struct Variable_ * Variable;
typedef struct Variable_Cache_ Variable_Cache;

/*------------------------------------------------------------------------*/

#include "varset.h"

/*------------------------------------------------------------------------*/

struct Variable_Cache_
{
  unsigned idx;
  VarSet * varsets;
};

/*------------------------------------------------------------------------*/

struct Variable_
{
  char * name;
  unsigned size;
  Variable_Cache cache;
  Variable next, next_chronological;
  struct Assignment_ * assignment;
  unsigned is_in_COI;
};

/*------------------------------------------------------------------------*/

extern void init_Variable();
extern void exit_Variable();

extern Variable new_Variable(const char *);
extern Variable find_Variable(const char *);
extern void forall_Variable(void (*)(Variable));
extern Variable generate_Symbol();
extern void reset_idx_cache_Variable();
extern void reset_varsets_cache_Variable();

#endif
