#ifndef _util_h_INCLUDED
#define _util_h_INCLUDED

/*------------------------------------------------------------------------*/

#include <stdio.h>
#include "config.h"

/*------------------------------------------------------------------------*/

extern unsigned pow2(unsigned i);
extern unsigned log2(unsigned i);
extern unsigned next_size(unsigned n);

extern void tab(unsigned i);
extern void putu(unsigned u, FILE * file);

extern void fatal(char *, char *, int, char *, ...);

extern void start_verbose(char *, ...);
extern void end_verbose(char *, ...);

extern void print_verbose(char *, ...);

extern void start_progress();
extern void progress();
extern void end_progress();

extern double get_time();

/*------------------------------------------------------------------------*/

#ifndef __GNUC__
# define __FUNCTION__ ((char*)0)
#endif

#ifndef __FILE__
# define __FILE__ 0
#endif

#ifndef __LINE__
# define __LINE__ 0
#endif

#define POSITION  __FUNCTION__, __FILE__, __LINE__

#ifdef DEBUG
# define assert(b) \
  do { if(!(b)) fatal(POSITION, "assertion failed\n"); } while(0)
#else
# define assert(b) do { } while(0)
#endif

/*------------------------------------------------------------------------*/

#endif
