#include <stdlib.h>

#include "stack.h"
#include "config.h"
#include "util.h"

/*------------------------------------------------------------------------*/

static unsigned num_allocated_stacks = 0 , num_resized_stacks = 0;

/*------------------------------------------------------------------------*/

Stack new_Stack()
{
  unsigned size;
  Stack res;

  num_allocated_stacks++;
  res = (Stack) malloc(sizeof(struct Stack_));
  size = 20;
  res -> sp = res -> bottom = (void**) calloc(size, sizeof(void*));
  res -> top = res -> bottom + size;

  return res;
}

/*------------------------------------------------------------------------*/

void free_Stack(Stack stack)
{
  free(stack -> bottom);
  stack -> bottom = stack -> sp = stack -> top = 0;
  free(stack);
}

/*------------------------------------------------------------------------*/

void resize_Stack(Stack stack)
{
  unsigned size;
  void ** old;

  num_resized_stacks++;
  size = 2 * (stack -> top - stack -> bottom);
  old = stack -> bottom;
  stack -> bottom = (void**) realloc(stack -> bottom, size * sizeof(void*));
  stack -> top = stack -> bottom + size;
  stack -> sp += stack -> bottom - old;
}

/*------------------------------------------------------------------------*/

void exit_Stack()
{
  print_verbose("stacks: allocated %u, resizes %u\n",
    num_allocated_stacks, num_resized_stacks);
}

/*------------------------------------------------------------------------*/
#ifdef DEBUG
/*------------------------------------------------------------------------*/

void * pop(Stack stack)
{
  void * res;

  assert(!is_mt_Stack(stack));
  res = * -- stack -> sp;

  return res;
}

/*------------------------------------------------------------------------*/

void push(Stack stack, void * elem)
{
  if(is_full_Stack(stack)) resize_Stack(stack);
  *stack -> sp ++ = elem;
}

/*------------------------------------------------------------------------*/
#endif
/*------------------------------------------------------------------------*/
