#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static char * buffer;
static unsigned buffer_size, buffer_pos;

static char ** lines;
static unsigned lines_size, lines_pos;

static int * cex;
static unsigned cex_size, cex_pos;

static void insert_char(char ch)
{
  if(buffer_pos >= buffer_size)
    buffer = (char*) realloc(buffer, buffer_size *= 2);
  
  buffer[buffer_pos++] = ch;
}

static void insert_line()
{
  if(lines_pos >= lines_size)
    lines = (char**) realloc(lines, sizeof(char*) * (lines_size *= 2));
  
  lines[lines_pos++] = strdup(buffer);
}

static char * start_of_cex_string = "Translation of Counterexample";
static int cex_started = 0;

static int read_line()
{
  char ch;
  int res;

  buffer_pos = 0;

  if(feof(stdin)) res = 0;
  else
    {
      while((ch = getc(stdin)) != EOF && ch != '\n') insert_char(ch);

      if(buffer_pos || ch == '\n')
	{
	  insert_char('\0');
	  if(cex_started) insert_line();
	  else
	  if(strcmp(start_of_cex_string, buffer) == 0)
	    {
	      cex_started = 1;
	      insert_line();
	    }
	  else 
	    { 
	      printf("%s\n", buffer);
	      fflush(stdout);
	    }
	  res = 1;
	}
      else res = 0;
    }
  
  return res;
}

static void init()
{
  buffer_pos = 0;
  buffer_size = 10;
  buffer = (char*) malloc(buffer_size);

  lines_pos = 0;
  lines_size = 10;
  lines = (char**) calloc(sizeof(char*), lines_size);

  cex_pos = 0;
  cex_size = 10;
  cex = (int*) calloc(sizeof(int), cex_size);
}

static void cleanup()
{
  int i;

  for(i = 0; i < lines_pos; i++) if(lines[i]) free(lines[i]);

  free(lines);
  free(buffer);
  free(cex);

  exit(0);
}

static int cmp(const void * a, const void * b)
{
  int res;

  res = strcmp(*(const char **) a, *(const char **) b);

  return res;
}

static void insert_cex(int start)
{
  if(cex_pos >= cex_size)
    cex = (int*) realloc(cex, sizeof(int) * (cex_size *= 2));
  
  cex[cex_pos++] = start;
}

static void remove_common()
{
  unsigned i, j;

  for(i = cex_pos - 1; i; i--)
    for(j = 0; *lines[cex[i - 1] + j]; j++)
      if(strcmp(lines[cex[i - 1] + j], lines[cex[i] + j]) == 0)
	{
	  free(lines[cex[i] + j]);
	  lines[cex[i] + j] = 0;
	}
}

static char * loops_starts_here_string = " LOOP STARTS HERE ---";

static void detect_loop()
{
  int i, j, match, mismatch;

  for(i = 0, match = 0; !match && i < cex_pos - 1; i++)
    {
      for(j = 0, mismatch = 0; !mismatch && *lines[cex[i] + j]; j++)
	mismatch = strcmp(lines[cex[i]+j], lines[cex[cex_pos-1] + j]) != 0;
      
      match = !mismatch;
    }
  
  if(match)
    {
      j = strlen(lines[cex[i - 1] - 2]) - strlen(loops_starts_here_string);
      lines[cex[i - 1] - 2][j] = '\0';
      strcat(lines[cex[i - 1] - 2], loops_starts_here_string);
    }
}

static void process_cex()
{
  if(cex_pos)
    {
      detect_loop();
      remove_common();
    }
}

static void print_lines()
{
  unsigned i;

  for(i = 0; i < lines_pos; i++)
    if(lines[i]) printf("%s\n", lines[i]);
}

static void sort_lines()
{
  int i, start;

  for(i = 0; i < lines_pos; i++)
    if(strcmp(start_of_cex_string, lines[i]) == 0)
      {
        i += 3;
	while(i < lines_pos && strncmp(lines[i], "--- ", 4) == 0)
	  {
	    i += 2;
	    if(i >= lines_pos) return;
	    start = i;
	    while(i < lines_pos && lines[i][0]) i++;
	    qsort(lines + start, i - start, sizeof(char*), cmp);
	    insert_cex(start);
	    i++;
	  }
      }
}

int main()
{
  init();
  while(read_line())
    ;

  sort_lines();
  process_cex();
  print_lines();
  
  cleanup();
  return 0;
}
