static unsigned f1, f2, i1, i2, out;
static int done, overflow;

#define BIT(s)  (1 << (s))
#define MASK(s) (~((~0) << (s)))

int main()
{
  int skip;
  unsigned i, j, checks, count;
  double num_overflows, skipped;

  skip = 1;

  checks = 0;
  count = 0;
  num_overflows = 0;
  skipped = 0;

  for(i = 0; i < BIT(17); i++)
    {
      overflow = 0;

      for(j = 0; (skip && !overflow) && j < BIT(17); j++)
	{
	  /* INIT */

	  i1 = i;
	  i2 = j;
	  f1 = i1;
	  f2 = i2;
	  done = 0;
	  overflow = 0;
	  out = 0;

	  count++;
	  checks++;
	  if((skip && count >= 100000) || (!skip && count >= 1000000))
	    {
	      printf(
  "%10u. i1 = %u, i2 = %u, overflows = %0.f (= %.2f%%), %0.f skipped\n",
		checks, i1, i2, num_overflows,
		100.0 * (((double) num_overflows) / ((double)checks)),
		skipped);
	      count = 0;
	    }

	  while(!done && !overflow)
	    {
	      /* NEXT */

/* done */
	      if(out & BIT(16)) done = 1;
	      else if(f1 & BIT(16)) done = 1;
	      else if(f2 == 0) done = 1;
	      else done = done;

/* overflow */

	      if(out & BIT(16)) overflow = 1;
	      else if(f1 & BIT(16)) overflow = 1;
	      else overflow = overflow;

/* out */
	      if(done) out = out;
	      else if((f2 & BIT(0)) && !(out & BIT(16)) && !(f1 & BIT(16)))
		{
		  out = (out + f1) & MASK(17);
		}
	      else out = out;

/* f1 */
	      if(done) f1 = f1;
	      else f1 <<= 1;

/* f2 */
	      if(done) f2 = f2;
	      else f2 >>= 1;
	    }
	  
	  if(overflow)
	    {
	      num_overflows++;
	      if(skip) skipped += BIT(17) - j;
	    }
	  else
	  if(((i1 * i2) & MASK(16)) != (out & MASK(16)))
	    {
	      printf("*** for i1 = %u, i2 = %u, i1 * i2 = %u  but  out = %u\n",
		i1, i2, ((i1 * i2) & MASK(16)), (out & MASK(16)));
	      exit(1);
	    }
	}
    }
  
  printf("%.0f overflows = %.2f%%, %.0f skipped = %.2f%%\n",
    num_overflows, 
    100.0 * (((double) num_overflows) / 1024.0 / 1024.0 / 1024.0 / 4.0),
    skipped,
    100.0 * (((double) skipped) / 1024.0 / 1024.0 / 1024.0 / 4.0));

  exit(0);
  return 1;
}
