#ifndef _list_h_INCLUDED
#define _list_h_INCLUDED

/*------------------------------------------------------------------------*/

#include "config.h"

/*------------------------------------------------------------------------*/

typedef struct List_ * List;

struct List_
{
  void * head;
  List tail;
};

/*------------------------------------------------------------------------*/

extern List cons(void *, List);
extern void free_List(List);
extern void forall_List(List, void(*)(void*));
extern List reverse_List(List);
extern unsigned length_List(List);

/*------------------------------------------------------------------------*/
#ifdef DEBUG
/*------------------------------------------------------------------------*/

extern void * car(List);
extern List cdr(List);

/*------------------------------------------------------------------------*/
#else
/*------------------------------------------------------------------------*/

#define car(l) ((l) -> head)
#define cdr(l) ((l) -> tail)

/*------------------------------------------------------------------------*/
#endif
/*------------------------------------------------------------------------*/

#endif
