#ifndef _graph_h_INCLUDED
#define _graph_h_INCLUDED

#include "var.h"

/*------------------------------------------------------------------------*/

typedef struct Graph_ * Graph;
typedef struct Node_ * Node;
typedef struct Edge_ * Edge;

struct Edge_
{
  Node dst;
  Edge next;
};

struct Node_
{
  Variable variable;
  unsigned idx, is_marked : 1, is_on_stack : 1;
  Edge * edges;
  unsigned size, count;
  Node next;
};

struct Graph_
{
  Node * nodes;
  unsigned count_nodes, size_nodes, max_nodes, lookup_nodes, visited_nodes;
  unsigned count_edges, size_edges, max_edges, lookup_edges, visited_edges;
  unsigned resize_nodes, resize_edges;
};

/*------------------------------------------------------------------------*/

extern Graph new_Graph();
extern void free_Graph();

extern void add_Edge(Graph, Variable, unsigned, Variable, unsigned);

extern Node find_Cycle(Graph);

extern void init_DFS(Graph);
extern void dfs(Graph, Variable, unsigned);
extern void forall_nonreachable_Graph(Graph, void (*)(Variable, unsigned));
extern void forall_reachable_Graph(Graph, void (*)(Variable, unsigned));
extern void exit_DFS(Graph);

/*------------------------------------------------------------------------*/

#endif
