#include <stdio.h>
#include <stdlib.h>

int main(int argc, char **argv)
{
  int i;

  int length=10, width=1;
  
  int expw = 1;
  int logl = 0;
  int temp = 1;
	

  for(i=1; i<argc; i++)
    {
      if(strcmp(argv[i], "-l") == 0)
        {
          if(++i >= argc)
            {
              fprintf(stderr, "*** argument to `-l' is missing\n");
            }

          length = (unsigned) atoi(argv[i]);
        }

      if(strcmp(argv[i], "-w") == 0)
        {
          if(++i >= argc)
            {
              fprintf(stderr, "*** argument to `-w' is missing\n");
            }

          width = (unsigned) atoi(argv[i]);
        }
     }

  for(i=0; i<width; i++)
	expw *= 2;

  while (temp < length)
	{
	 temp *= 2;
	 logl++; }

/*  printf("MODULE main\n"); */
  printf("VAR \n");
  for (i=0; i< length; i++)
    printf(" a%d[%d]\n",i,width);
  for (i=0; i< length; i++)
    printf(" c%d[%d]\n",i,width);
printf("\n");
    printf(" vin[%d]\n",width);
    printf(" aout[%d]\n",width);
    printf(" cout[%d]\n",width);

printf("\n");
    printf(" afull[1] \n");
   printf(" cfull[1] \n");
   printf(" op[1] \n");
printf(" atop[%d] \n", logl);
printf(" cread[%d] \n", logl);
printf(" cwrite[%d] \n", logl);


printf("\n");
printf("INIT\n");
printf("( \n");
printf("afull = 0 & atop=0 & cfull = 0 & cread=0 & cwrite=0 & \n");
printf("cout=0&aout=0  \n");
  for (i=0; i< length; i++)
    printf("& a%d = 0\n",i);
  for (i=0; i< length; i++)
    printf("& c%d = 0 \n",i);
printf(") \n");

printf("DEFINE\n");
printf(" aReadOK := case !(atop = 0) | afull : 1; 1 : 0; esac;\n");
printf(" aWriteOK := case !afull : 1; 1 : 0; esac;\n");
printf(" cReadOK := case !(cread = cwrite) | cfull : 1; 1 : 0; esac;\n");
printf(" cWriteOK := case !(cread = cwrite) | !cfull : 1; 1 : 0; esac;\n");
printf(" read := case aReadOK & cReadOK & !op : 1; 1 : 0; esac;\n");
printf(" write := case aWriteOK & cWriteOK & op : 1; 1 : 0; esac;\n");

printf("ASSIGN\n");
printf("    next(atop) := case \n");
printf("        read & atop = 0: %d;\n",length-1);
printf("-- This is due to the mod semantics of inc and dec\n");
printf("        read & !(atop = 0): dec(atop);\n");
printf("        write & atop = %d: 0;\n",length-1);
printf("        write & !(atop = %d): inc(atop);\n",length-1);
printf("        1: atop;\n");
printf("        esac; \n");

printf("    next(afull) := case\n");
printf("        write &  atop = %d : 1;\n",length - 1);
printf("        read: 0;\n");
 printf("       1: afull;\n");
 printf("       esac;\n");

printf("    next(cread) := case\n");
printf("        read & cread = %d : 0; \n",length-1);
printf("        read & !(cread = %d) : inc(cread); \n",length-1);
printf("        1: cread;\n");
printf("        esac;\n");

printf("    next(cwrite) := case\n");
printf("        write & cwrite = %d: 0 ;\n",length-1);
printf("        write & !(cwrite = %d): inc(cwrite) ;\n",length-1);
printf("        1: cwrite;\n");
printf("        esac;\n");

printf("    next(cfull) := case\n");
printf("        write & (inc(cwrite) = cread | cwrite = %d & cread = 0): 1 ;\n",length-1);
printf("        read: 0;\n");
printf("        1: cfull;\n");
printf("        esac;\n");

for (i=0; i< length-1; i++)
{
printf("    next(a%d) :=\n",i); 
printf("        case\n");
printf("         read: a%d;\n",i+1);
printf("         write & atop = %d: vin;\n",i);
printf("         1: a%d;\n",i);
printf("        esac; \n");
}

printf("    next(a%d) :=\n",length-1); 
printf("        case\n");
printf("         write & atop = %d: vin;\n",length-1);
printf("         1: a%d;\n",length-1);
printf("        esac; \n");

for (i=0; i< length; i++)
{
printf("    next(c%i) := \n",i);
printf("        case\n");
printf("        write & cwrite = %d: vin;\n",i);
printf("        1: c%d;\n",i);
printf("        esac;\n");
}


printf("    next(aout) := \n");
printf("        case\n");
printf("        read: a0;\n");
printf("        1: 0;\n");
printf("        esac;\n");

printf("    next(cout) := \n");
printf("        case\n");
for (i=0; i< length; i++)
printf("        read & cread = %d: c%d;\n",i,i);
printf("        1:0;\n");
printf("        esac;\n");

printf("SPEC\n");
printf("AG ( aReadOK = cReadOK & aWriteOK = cWriteOK & aout=cout )\n");


  exit(0);
  return 0;
}
