#ifndef _ctl_h_INCLUDED
#define _ctl_h_INCLUDED

/*------------------------------------------------------------------------*/

#include "stack.h"
#include "var.h"
#include "varset.h"
#include "config.h"

/*------------------------------------------------------------------------*/

typedef enum CTL_Tag_ CTL_Tag;
typedef struct CTL_ * CTL;
typedef struct CTL_Base_ CTL_Base;
typedef union CTL_Cache_ CTL_Cache;
typedef union CTL_Cache2_ CTL_Cache2;
typedef struct CTL_CNF_Cache_ CTL_CNF_Cache;

/*------------------------------------------------------------------------*/

enum CTL_Tag_
{
# ifdef DEBUG
  INVALID_Tag,
# endif

  CONSTANT_Tag,
  AND_Tag,
  OR_Tag,
  EQUIV_Tag,
  IMPLIES_Tag,
  NOT_Tag,
  CURRENT_Tag,
  NEXT_Tag,
  EQUAL_Tag,
  INC_Tag,
  DEC_Tag,
  ADD_Tag,
  SUB_Tag,
  NUMBER_Tag,
  CASE_Tag,
  COLON_Tag,
  SWITCH_Tag,
  EX_Tag,
  EF_Tag,
  EG_Tag,
  AX_Tag,
  AF_Tag,
  AG_Tag
};

/*------------------------------------------------------------------------*/

struct CTL_Base_
{
  Variable variable;
  unsigned idx;
};

/*------------------------------------------------------------------------*/

struct CTL_CNF_Cache_
{
  Variable variable;
  CTL constraint[2];
};

/*------------------------------------------------------------------------*/

union CTL_Cache_
{
  unsigned number;
  VarSet varset;
  Variable variable;
  CTL_CNF_Cache cnf;
  CTL unary;
  CTL binary[2];
};

/*------------------------------------------------------------------------*/

union CTL_Cache2_
{
  CTL unary;
};

/*------------------------------------------------------------------------*/

struct CTL_
{
  CTL_Tag tag;

  unsigned ref;

  union
  {
    CTL_Base base;
    unsigned number;
    CTL arg[2];
  }
  data;

  CTL next;		/* linear collision detection */
  CTL_Cache cache;
  CTL_Cache2 cache2;

  unsigned is_marked : 2;

  /* The next fields are calculated at creation time and never changed
   * later.
   */
  unsigned size;

  unsigned is_propositional : 1;
  unsigned is_ACTL : 1;
  unsigned is_ECTL : 1;
  unsigned is_CLAUSE : 1;
  unsigned is_flattened : 1;
  unsigned is_cnf : 1;
  unsigned is_nnf : 1;
  unsigned is_current : 1;
};

/*------------------------------------------------------------------------*/

#define set_mark0_CTL(f) do { (f) -> is_marked |= 1; } while(0)
#define set_mark1_CTL(f) do { (f) -> is_marked |= 2; } while(0)
#define get_mark0_CTL(f) (((f) -> is_marked & 1) != 0)
#define get_mark1_CTL(f) (((f) -> is_marked & 2) != 0)

/*------------------------------------------------------------------------*/

#define is_true_CTL(f) \
  ((f) -> tag == NUMBER_Tag && (f) -> data.number == 1)

/*------------------------------------------------------------------------*/

#define is_false_CTL(f) \
  ((f) -> tag == NUMBER_Tag && (f) -> data.number == 0)

/*------------------------------------------------------------------------*/

#define is_vector_CTL(f) \
  ((f) -> data.base.variable -> size == (f) -> data.base.idx)

/*------------------------------------------------------------------------*/

extern CTL true_CTL();
extern CTL false_CTL();
extern CTL current_CTL(Variable, unsigned);
extern CTL next_CTL(Variable, unsigned);
extern CTL number_CTL(unsigned);
extern CTL unary_CTL(CTL_Tag, CTL);
extern CTL binary_CTL(CTL_Tag, CTL, CTL);
extern CTL copy_CTL(CTL);
extern void free_CTL(CTL);
extern void exit_CTL();
extern void init_CTL();

extern void unmark_CTL(CTL);
extern unsigned count_CTL(CTL);
extern unsigned num_clauses(CTL);

/*------------------------------------------------------------------------*/

extern unsigned priority_CTL(CTL);
extern void print_CTL(CTL);
extern CTL sub_prop_CTL(CTL, unsigned current_index, unsigned next_index);
extern CTL cnf(CTL);
extern CTL nnf_CTL(CTL,int);
extern unsigned width_CTL(CTL);
extern unsigned contains_var_with_width(CTL);
extern int check_width_CTL(unsigned, CTL);
extern void reset_number_cache(CTL);
extern void reset_unary_cache(CTL);
extern void reset_unary_cache2(CTL);
extern void reset_variable_cache(CTL);
extern void push_CTL(Stack,CTL);

#endif
