/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.visual;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import salvo.jesus.graph.javax.swing.JButtonColorListener;
import salvo.jesus.graph.javax.swing.JColor;
import salvo.jesus.graph.javax.swing.JFontChooser;
import salvo.jesus.graph.javax.swing.JTabPanel;
import salvo.jesus.graph.visual.FollowVertexLabelCheckBoxListener;
import salvo.jesus.graph.visual.VisualEdge;
import salvo.jesus.graph.visual.VisualGraphComponent;

class FontChooserPanel
extends JTabPanel {
    VisualGraphComponent vgcomponent;
    JFontChooser fontchooser;
    JLabel textLabel;
    JTextArea textarea;
    JLabel fontcolorlabel;
    JButton fontcolorbutton;
    JButtonColorListener fontcolorlistener;
    JColor fontcolor;
    JCheckBox followLabel;

    FontChooserPanel(VisualGraphComponent vgcomponent) {
        this.vgcomponent = vgcomponent;
        this.initFontandColorChooser(vgcomponent.getFont(), vgcomponent.getFontcolor());
    }

    private void initFontandColorChooser(Font font, Color fontcolor) {
        this.fontchooser = new JFontChooser(font);
        this.textarea = new JTextArea(this.vgcomponent.getLabel());
        this.textarea.setEditable(true);
        this.textarea.setRows(4);
        JScrollPane scroller = new JScrollPane(this.textarea);
        scroller.setVerticalScrollBarPolicy(20);
        scroller.setHorizontalScrollBarPolicy(30);
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BorderLayout());
        textPanel.add((Component)scroller, "Center");
        if (this.vgcomponent instanceof VisualEdge) {
            VisualEdge vEdge = (VisualEdge)this.vgcomponent;
            this.followLabel = new JCheckBox("Dynamically generate label from vertices");
            this.followLabel.addItemListener(new FollowVertexLabelCheckBoxListener(vEdge.getEdge(), this.textarea));
            if (vEdge.getEdge().isFollowVertexLabel()) {
                this.followLabel.setSelected(true);
                this.textarea.disable();
            }
            textPanel.add((Component)this.followLabel, "North");
        }
        this.fontcolor = new JColor(fontcolor);
        this.fontcolorlabel = new JLabel("Font Color:");
        this.fontcolorbutton = new JButton();
        this.fontcolorlistener = new JButtonColorListener(this, this.fontcolor, this.fontcolorbutton);
        this.fontcolor.addActionListener(this.fontcolorlistener);
        this.fontcolorbutton.addActionListener(this.fontcolorlistener);
        this.fontcolor.setColor(this.fontcolor.getColor());
        JPanel colorspanel = new JPanel();
        colorspanel.setLayout(new GridLayout(0, 2));
        colorspanel.add(this.fontcolorlabel);
        colorspanel.add(this.fontcolorbutton);
        colorspanel.add(Box.createRigidArea(new Dimension(5, 5)));
        colorspanel.add(Box.createRigidArea(new Dimension(5, 5)));
        this.setLayout(new BorderLayout());
        this.add((Component)this.fontchooser, "North");
        this.add((Component)textPanel, "Center");
        this.add((Component)colorspanel, "South");
    }

    public void apply() {
        this.vgcomponent.setFont(this.fontchooser.getSelectedFont());
        this.vgcomponent.setFontcolor(this.fontcolor.getColor());
        if (this.vgcomponent instanceof VisualEdge) {
            VisualEdge vEdge = (VisualEdge)this.vgcomponent;
            vEdge.getEdge().setFollowVertexLabel(this.followLabel.isSelected());
            if (!this.followLabel.isSelected()) {
                vEdge.getEdge().setLabel(this.textarea.getText());
            }
        } else {
            this.vgcomponent.setLabel(this.textarea.getText());
        }
    }

    public void ok() {
        this.apply();
    }
}

