// Name: 
// Andrew ID: 
// Approximate number of hours spent on this assignment: 

import java.util.*;
import java.io.*;

public class Contacts
{
    private static final int MAX_CONTACTS = 1000;
    private Contact[] contacts;
    private int numContacts;
    
    
    // this constructor takes a filename (a String), opens the file, and
    // assuming it is openable, loads the contacts array with data from the file
    public Contacts(String filename)
    {
        contacts = new Contact[MAX_CONTACTS];
        numContacts = 0;
        Scanner s = getFileScanner(filename);
        if (s != null)
        {
            while (s.hasNext())
            {
                // create a new Contact with data from the file (must create appropriate constructor in Contact class)
                Contact c = new Contact();
                contacts[numContacts] = c;
                numContacts++;
            }
        }
    }
    
    public String toString()
    {
        String s = "There are " + numContacts + " contacts:\n";
        for (int i = 0; i < numContacts; i++)
            s += contacts[i] + "\n";
        return s;
    }
    
    
    // helper methods to open files for reading/writing
    public static Scanner getFileScanner(String filename)
    {
        Scanner myFile;
        try { myFile = new Scanner(new FileReader(filename)); }
        catch (Exception e)
        {
            System.out.println("File not found: " + filename);
            return null;
        }
        return myFile;
    }
    
    public static PrintWriter getFileWriter(String filename)
    {
        PrintWriter outFile;
        try { outFile = new PrintWriter(filename); }
        catch (Exception e)
        {
            System.out.println("Error opening file: " + filename);
            return null;
        }
        return outFile;
    }
    
    public static void main(String[] args)
    {
        Contacts myList = new Contacts("names.txt");
        System.out.println(myList);
        // more tests should go here...
    }
}