/***************************************************************************
                          utils.h  -  description
                             -------------------
    begin                : Wed Aug 8 2001
    copyright            : (C) 2001 by Yinglian Xie
    email                : ylxie@cs.cmu.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// utils.h: definition of types, global vars and help functions
//
//////////////////////////////////////////////////////////////////////


#ifndef UTILS_H
#define UTILS_H

#include <list>
#include <vector>
#include <functional>
#include <string>

using namespace std;

#define HOSTLEN       4
#define MAXSTRSIZE    2048
#define MAX_INT       0x7fffffff
#define DEFAULT_PORT  7018
#define DIGITS        "0123456789"
#define PASSWDFILE    "/etc/passwd"
#define GROUPFILE     "/etc/group"


/*
 *  Type define
 */
typedef unsigned char  uchar;
typedef unsigned int   uint;
typedef list<string>   TStrList;
typedef vector<string> TStrArray; 

typedef struct{
	uchar  ip[HOSTLEN];
	short  port;
}Thost;
typedef list<Thost, allocator<Thost> > THostList;

class Host_eq: public unary_function<Thost, int>
{
	Thost h;
 public:
	explicit Host_eq(const Thost& hh): h(hh){}
	int operator() (const Thost& host) const{
		if ((memcmp(host.ip, h.ip, HOSTLEN) == 0) && 
		    (host.port == h.port))
			return 1;
		else
			return 0;
	}
};


/*
 *  Variable define
 */
extern uchar local_ip[HOSTLEN];
extern short local_port;

/*
 *  Function define
 */
void mingle_debug1(const char* errstring);
void mingle_debug2(const char* errstring, int errnum);
int  get_absolute_fname(string& rname, string& aname);
int  get_next_item(string& strcd, string& stritem, string::size_type pos);
int  is_ip(string ipstr);
int  convert_host_to_ip(string hoststr, uchar hostip[HOSTLEN]);

string get_ustring(uid_t uid);
string get_gstring(gid_t gid);
int    get_uid(string ustring);
int    get_gid(string gstring);
int    get_gid(uid_t uid);

#endif // UTILS_H
