/***************************************************************************
                          master.cpp -  description
                             -------------------
    begin                : Wed Aug 8 2001
    copyright            : (C) 2001 by Yinglian Xie
    email                : ylxie@cs.cmu.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
// master.cpp: implementation for the CMaster class.
//
//////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <errno.h>
#include <list>
#include <string>
#include "master.h"
#include "security.h"
#include "utils.h"
using namespace std;

CMaster::CMaster()
{
}

CMaster::~CMaster()
{
}

void CMaster::setup_signon(string dir)
{
	m_signondir = dir;
	m_signonfile = m_signondir + "/" + SIGNON_FNAME;
	read_signon();
}

void CMaster::setup_pubkey(string pubkey)
{
	m_pubkey = pubkey;
}

/////////////////////////////////////////////////////////////////
//  functions to set up mingle cluster/master server

void CMaster::setup_cluster(string hostlist)
{
	string::size_type pos_s, pos_e = 0, pos_t;


	while (pos_e < hostlist.length()){
		string ip, port, host;

		/* extract one host */
		pos_s = hostlist.find_first_of("\"", pos_e);
		if (pos_s > hostlist.length())
			break;
		pos_e = hostlist.find_first_of("\"", pos_s+1);
		if (pos_e > hostlist.length())
			break;
		host = hostlist.substr(pos_s+1, pos_e-pos_s-1);
		pos_e ++;
		pos_t = host.find(':');
		if (pos_t < host.length()){
			ip = host.substr(0, pos_t);
			port = host.substr(pos_t+1, MAX_INT);
		}else{
			ip = host;
		}
		
		Thost newhost;
		if (ip == "LOCAL"){
			memcpy(newhost.ip, local_ip, HOSTLEN);
			newhost.port = local_port;
			m_chosts.push_front(newhost);
			continue;
		}

		/* get ip address */
		if (convert_host_to_ip(ip, newhost.ip) == -1)
		    continue;

		/* get port number */
		if (port.empty())
			newhost.port = DEFAULT_PORT;
		else{
			if ( (newhost.port = atoi(port.c_str())) == 0)
				continue;
		}

		m_chosts.push_front(newhost);
	}
}

void CMaster::set_master_host(string masterhost, int port)
{
	if (convert_host_to_ip(masterhost, m_ip) == -1){
		mingle_debug1("\nCReqQueue::set_master_host() failure");
	        m_port = 0;
	}else
		m_port = port;
}


/////////////////////////////////////////////////////////////////
//   user sign-on functions

/*
 * register_mid: register a new mingle id in the mingle cluster
 *               need to create a pub-pri key pair 
 */
int CMaster::register_mid(string mgid, string passwd, string& errstr)
{
	/* check if the mingle id already exists */
	TSignonSet::iterator i;
	for (i = m_muser.begin(); i != m_muser.end(); i ++){
		if (i->mgid == mgid){
			errstr = "Error: The mingle id already exists.\n";
			return -1;
		}
	}


	/* generate a pair of pub-pri key */
	Signon_Record newr;
	newr.mgid = mgid;
	MD5hash(passwd, newr.hashpwd);
	
	newr.prikey = m_signondir + "/pri-" + mgid;
	newr.pubkey = m_signondir + "/pub-" + mgid;
	generate_RSA_key(newr.prikey.c_str(), newr.pubkey.c_str());

	/* update user list file */
	m_muser.push_back(newr);
	flush_signon(); 
	
	return 0;
}

/*
 * change_passwd: change passwd for a mingle user
 */
int CMaster::change_passwd(string mgid, string oldpwd, string newpwd)
{
	/* check if the mingle id already exists */
	TSignonSet::iterator i;
	for (i = m_muser.begin(); i != m_muser.end(); i ++){
		if (i->mgid == mgid){
			string hashpwd;
			MD5hash(oldpwd, hashpwd);

			if (hashpwd == i->hashpwd){
				i->hashpwd.erase();
				MD5hash(newpwd, i->hashpwd);
				flush_signon();
				return 0;
			}else{
				return -1;
			}
		}
	}

	return -1;
}


/* get_prikey: get user's private key, need to check mgid and password
 *             return: 0: success
 *                    -1: permission denied
 */
int CMaster::get_prikey(string mgid, string passwd, string& prikey)
{
	/* check if the mingle id already exists */
	TSignonSet::iterator i;
	for (i = m_muser.begin(); i != m_muser.end(); i ++){
		if (i->mgid == mgid){
			string hashpwd;
			MD5hash(passwd, hashpwd);

			if (hashpwd == i->hashpwd){
				read_RSA_key(i->prikey, prikey);
				return 0;
			}else{
				return -1;
			}
		}
	}

	/* the specified mgid does not exist */
	return -1;
}

/* get_pubkey: get user's public key
 *             return: 0: success
 *                    -1: the specified mingle id does not exist
 */
int CMaster::get_pubkey(string mgid, string& pubkey)
{
	/* check if the mingle id already exists */
	TSignonSet::iterator i;
	for (i = m_muser.begin(); i != m_muser.end(); i ++){
		if (i->mgid == mgid){
			read_RSA_key(i->pubkey, pubkey);
			return 0;
		}
	}

	/* the specified mgid does not exist */
	return -1;
}


/////////////////////////////////////////////////////////////////
//  functions to read and store signon info

/*
 * flush_signon: flush signon info into disk
 *               format: mgid:password:public-key:private-key
 */
void CMaster::flush_signon()
{
	FILE *fp;

	/* open signon file for appending */
	if (!(fp = fopen(m_signonfile.c_str(), "w"))){
		mingle_debug2("\nCMaster::open signon info file error", errno);
		return;
	}

	TSignonSet::iterator i;
	for (i = m_muser.begin(); i != m_muser.end(); i ++){
		fprintf(fp, "%s:%s:%s:%s\n", 
			i->mgid.c_str(), i->hashpwd.c_str(),
			i->pubkey.c_str(), i->prikey.c_str());
	}

	/* close signon info file */
	fclose(fp);
}

/*
 * read_signon: read signon info from disk and init record set
 */
void CMaster::read_signon()
{
	FILE *fp;
	char buf[MAXSTRSIZE];

	if (!(fp = fopen(m_signonfile.c_str(), "r"))){
		mingle_debug2("\nCMaster::No existing sign-on info file. Will create one now...", errno);
		return;
	}

	while (fgets(buf, MAXSTRSIZE, fp)){
		string line = buf;
		string::size_type pos = 0, pos1;
		
		Signon_Record newr;

		pos = line.find_first_of("\n:", pos);
		newr.mgid = line.substr(0, pos);

		pos1 = line.find_first_of("\n:", ++pos);
		newr.hashpwd = line.substr(pos, pos1-pos);
		pos = pos1++;

		pos1 = line.find_first_of("\n:", ++pos);
		newr.pubkey = line.substr(pos, pos1-pos);
		pos = pos1++;

		pos1 = line.find_first_of("\n:", ++pos);
		newr.prikey = line.substr(pos, pos1-pos);

		m_muser.push_back(newr);
	}

	fclose(fp);
}

