/***************************************************************************
                          Fdmanager.h  -  description
                             -------------------
    begin                : Mon Sep 17 2001
    copyright            : (C) 2001 by Yinglian Xie
    email                : ylxie@cs.cmu.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// fdmanager.h: interface for the CFdManager class.
//
//////////////////////////////////////////////////////////////////////

#ifndef FDMANAGER_H
#define FDMANAGER_H

#include <sys/types.h>
#include <list>

using namespace std;

class CReceiver;
class CSender;

typedef list<int> FdList;

/*
 * ------- class CFdManager ------------
 */
class CFdManager {
private:
	fd_set  m_fdRset;
	fd_set  m_fdWset;
	
	FdList  m_rFdSet;  // read Fd Set
	FdList  m_wFdSet;  // write Fd set

public:
	CReceiver *m_receiver;
	CSender   *m_sender;
	
	int m_netlfd;      // network socket listen fd
	int m_unixlfd;     // unix domain socket listen fd
	int m_maxfd;	
	int m_netUp;       // whether network is up
	int m_unixUp;      // whether unix socket is up
		
public: 
	CFdManager();
	~CFdManager();

	/* functions to set member var m_netUp and m_unixUp */
	void set_net_up();
	void set_net_down();
	void set_unix_up();
	void set_unix_down();
		
	/* main function of the program */
	void loop_select();	

	/* interface functions for set read and write fd-set */
	void set_rfd(int fd);
	void set_wfd(int fd);
};

#endif // FDMANAGER_H
