/***************************************************************************
                          Fdmanager.cpp  -  description
                             -------------------
    begin                : Mon Sep 17 2001
    copyright            : (C) 2001 by Yinglian Xie
    email                : ylxie@cs.cmu.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// fdmanager.cpp: implementation for the CFdManager class.
//
//////////////////////////////////////////////////////////////////////

#include <sys/time.h>
#include <sys/types.h>
#include <stdio.h>
#include <unistd.h>
#include <list>
#include <algorithm>
#include <errno.h>
#include "fdmanager.h"
#include "sender.h"
#include "receiver.h"

using namespace std;

#define  MAX(a,b) (((a > b)) ? (a) : (b))

//////////////////////////////////////////////////////////////////////
//  class  CFdManager implementation
//////////////////////////////////////////////////////////////////////

CFdManager::CFdManager()
{
	m_netlfd = m_unixlfd = 0;
}	

CFdManager::~CFdManager()
{
}


/*
 * interface functions for set variable m_netUp and m_unixUp
 */
void CFdManager::set_net_up()
{
	m_netUp = 1;
}

void CFdManager::set_net_down()
{
	m_netUp = 0;
}

void CFdManager::set_unix_up()
{
	m_unixUp = 1;
}

void CFdManager::set_unix_down()
{
	m_unixUp = 0;
}


/*
 * interface functions for set read and write fd-set
 */
void CFdManager::set_rfd(int fd)
{
	FdList::iterator i = find(m_rFdSet.begin(), m_rFdSet.end(), fd);
	if (i == m_rFdSet.end())
		m_rFdSet.push_back(fd);

	FD_SET(fd, &m_fdRset);
	m_maxfd = MAX(m_maxfd, fd + 1);
}

void CFdManager::set_wfd(int fd)
{
	FdList::iterator i = find(m_wFdSet.begin(), m_wFdSet.end(), fd);
	if (i == m_wFdSet.end())
		m_wFdSet.push_back(fd);

	FD_SET(fd, &m_fdWset);
	m_maxfd = MAX(m_maxfd, fd + 1);
}

/* 
 * main loop, select any fd that is ready to proceed 
 */
void CFdManager::loop_select()
{	
	FdList::iterator i;

	/* initialize fdset */	
	FD_ZERO(&m_fdRset);
	FD_ZERO(&m_fdWset);
	
	m_maxfd = MAX(m_netlfd, m_unixlfd) + 1;
	
	while (1){
		/* set unix domain listen sd and network listen sd */
		if (m_unixUp)
			FD_SET(m_unixlfd, &m_fdRset);
		if (m_netUp)
			FD_SET(m_netlfd, &m_fdRset);	

		/* set all unready rfd and wfd */
		for (i = m_rFdSet.begin(); i != m_rFdSet.end(); i ++){
			int sd = *i;
			FD_SET(sd, &m_fdRset);
			m_maxfd = MAX(m_maxfd, sd + 1);
		}
				
		/* socket ready for write 	*/
		for (i = m_wFdSet.begin(); i != m_wFdSet.end(); i ++){
			int sd = *i;
			FD_SET(sd, &m_fdWset);
			m_maxfd = MAX(m_maxfd, sd + 1);
		}

		/* select ready fd now */
		if (select(m_maxfd, &m_fdRset, &m_fdWset, 0, 0) == -1){
			if (errno == EINTR){
				continue;
			}else{
				printf("CFdManager::select() error! exit now...\n");
				exit(0);
			}
		}
		
		// unix domain listen socket ready: local user
		if ((m_unixUp) && (FD_ISSET(m_unixlfd, &m_fdRset))){
			int sd = m_receiver->request_accept(m_unixlfd);
			if (sd > 0)
				set_rfd(sd);
		}
			
		/* network listen socket ready,
			we have a new connection for incoming request */
		if ((m_netUp) && (FD_ISSET(m_netlfd, &m_fdRset))){
			int sd = m_receiver->request_accept(m_netlfd);
			if (sd > 0)
				set_rfd(sd);
		}	

		/* socket ready for read */
		i = m_rFdSet.begin();
		while (i != m_rFdSet.end()){
			int sd = *i;
			FdList::iterator oi = i;
			i ++;

			if (FD_ISSET(sd, &m_fdRset)){
				if (m_receiver->keep_reading(sd) == 0){
					// we finished reading here
					m_rFdSet.erase(oi);
					FD_CLR(sd, &m_fdRset);
				}
			}
		}
				
		/* socket ready for write */		
		i = m_wFdSet.begin();
		while (i != m_wFdSet.end()){
			int sd = *i;
			FdList::iterator oi = i;
			i ++;
			
			if (FD_ISSET(sd, &m_fdWset)){
				if (m_sender->keep_writing(sd) == 0){
					// we finished writing here
					m_wFdSet.erase(oi);
					FD_CLR(sd, &m_fdWset);
				}
			}
		}
		
	} // end while (1)
}
