/***************************************************************************
                          utils.cpp  -  description
                             -------------------
    begin                : Wed Aug 8 2001
    copyright            : (C) 2001 by Yinglian Xie
    email                : ylxie@cs.cmu.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// utils.cpp: implementation of the help functions
//
//////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <string>
#include "utils.h"

using namespace std;

extern FILE *errfp;

void mingle_debug1(const char* errstring)
{
#ifdef MINGLE_VERBOSE
	fprintf(errfp, "%s", errstring);
	fflush(errfp);
#endif	
}

void mingle_debug2(const char *errstring, int errnum)
{
#ifdef MINGLE_VERBOSE
	fprintf(errfp, "%s (%s)", errstring, strerror(errnum));
	fflush(errfp);
#endif	
}

/*
 * get_absolute_fname: convert a relative path name into an absolute path name
 * 
 */
int get_absolute_fname(string& rname, string& aname)
{
	string::size_type pos;
	char buf[1024];

	/* make a uniform dir name with, remove any "/" suffix */
	pos = rname.find_last_of("/"); 
	if ( ((pos < rname.length() - 1) && (rname[pos+1] == ' '))||
	     (pos == rname.length() - 1) ){
		rname.erase(pos, 1);
	}
	
	/* check if relative path name, if it is, make it an
	 absolute path name */
	pos = rname.find_first_of("/");
	if ((pos > rname.length()) || 
	    ((pos > 0) && (rname[pos-1] != ' '))){
		if (getcwd(buf, 1024) == 0){
			mingle_debug2("\nCUserGroup::get_absolute_fname(): get cwd error", errno);
			return -1;
		}
		aname = buf;
		aname += "/";
		aname += rname;
	}else
		aname = rname;

	/* now remove all the ./ or ../ part in the path */
	pos = aname.find("/./");
	while (pos < aname.length()){
		aname.erase(pos+1, 2);
		pos = aname.find("/./");
	}
	
	pos = aname.find("/../");
	while (pos < aname.length()){
		string::size_type p = aname.find_last_of("/", pos-1);
		aname.erase(p+1, pos-p+3);
		pos = aname.find("/../");
	}

	return 0;
}

/*
 * get_next_item: help function to get next item in a string seperated by blanks or \n
 *                return  0: extract item successfully
 *                       -1: no more items in the string
 */
int get_next_item(string& strcd, string& stritem, string::size_type pos)
{
	string::size_type pos1, pos2;

	if (pos > strcd.length()) 
	    return -1;

	pos1 = strcd.find_first_not_of(" \r\n", pos);
	if (pos1 > strcd.length())
		return -1;
	
	pos2 = strcd.find_first_of(" \r\n", pos1);
	stritem = strcd.substr(pos1, pos2-pos1);
	return pos2;
}


/*
 * is_ip: help function: check if a string is an ip address string
 */
int is_ip(string ipstr)
{
	string::size_type stpos = 0, edpos = 0;

	int i = 0;
	while (i < 4){	
		stpos = ipstr.find_first_of(DIGITS, edpos);
		if (stpos > ipstr.length()){
			return 0;
		}
		edpos = ipstr.find_first_of(". \r\n", stpos);
		
		string digstr = ipstr.substr(stpos, edpos - stpos);
		int num = atoi(digstr.c_str());
		
		if ((num < 0) || (num > 255))
			return 0;
		i ++;	
		digstr.erase();		
	}
	
	if ((edpos > ipstr.length()) || (ipstr[edpos] == ' ') || 
	    (ipstr[edpos] == '\n') || (ipstr[edpos] == '\r'))
		return 1;
	else
		return 0;	
}


/*
 * convert_host_to_ip: help function: convert a host string into an ip address hostip
 */
int convert_host_to_ip(string hoststr, uchar hostip[HOSTLEN])
{
	struct hostent *he;
	int host;
	
	if (is_ip(hoststr)){
		inet_aton(hoststr.c_str(), (in_addr *)&host);
		memcpy(hostip, &host, 4);
	}else{
		if (!(he = gethostbyname(hoststr.c_str()))){
			return -1;
		}else{
			memcpy(hostip, he->h_addr_list[0], 4);
		}						
	}
	return 0;
}



/*
 * get_ustring: get user name from uid
 */
string get_ustring(uid_t uid)
{
	string ustring, input;
	char buf[MAXSTRSIZE];
	uid_t id;

	FILE *fp;
	if (!(fp = fopen(PASSWDFILE, "r")))
		return ustring;

	while (fgets(buf, MAXSTRSIZE, fp)){
		input = buf;
		string::size_type pos = input.find(':');
		ustring = input.substr(0, pos);

		string::size_type pos_s, pos_e;
		pos_s = input.find_first_of(":", ++pos);
		pos_e = input.find_first_of(":", pos_s+1);
		id = atoi(input.substr(pos_s+1, pos_e-pos_s-1).c_str());
		if (id == uid)
			break;
	}
	
	fclose(fp);
	return ustring;
}

/*
 * get_gstring: get group name from gid
 */
string get_gstring(gid_t gid)
{
	string gstring, input;
	char buf[MAXSTRSIZE];
	gid_t id;

	FILE *fp;
	if (!(fp = fopen(GROUPFILE, "r")))
		return gstring;

	while (fgets(buf, MAXSTRSIZE, fp)){
		input = buf;
		string::size_type pos = input.find(':');
		gstring = input.substr(0, pos);

		string::size_type pos_s, pos_e;
		pos_s = input.find_first_of(":", ++pos);
		pos_e = input.find_first_of(":", pos_s+1);
		id = atoi(input.substr(pos_s+1, pos_e-pos_s-1).c_str());
		if (id == gid)
			break;
	}
	
	fclose(fp);
	return gstring;
}

/*
 * get_uid: get uid from user name
 */
int  get_uid(string ustring)
{
	char buf[MAXSTRSIZE];
	int id = -1;
	string input;

	FILE *fp;
	if (!(fp = fopen(PASSWDFILE, "r")))
		return -1;

	while (fgets(buf, MAXSTRSIZE, fp)){
		input = buf;
		string::size_type pos = input.find(':');
		if (ustring == input.substr(0, pos)){
			string::size_type pos_s, pos_e;
			pos_s = input.find_first_of(":", ++pos);
			pos_e = input.find_first_of(":", pos_s+1);
			id = atoi(input.substr(pos_s+1, pos_e-pos_s-1).c_str());
			break;
		}
	}
	
	fclose(fp);
	return id;
}


/*
 * get_gid: get gid from group name
 */
int  get_gid(string gstring)
{
	char buf[MAXSTRSIZE];
	int id = -1;
	string input;

	FILE *fp;
	if (!(fp = fopen(GROUPFILE, "r")))
		return -1;

	while (fgets(buf, MAXSTRSIZE, fp)){
		input = buf;
		string::size_type pos = input.find(':');
		if (gstring == input.substr(0, pos)){
			string::size_type pos_s, pos_e;
			pos_s = input.find_first_of(":", ++pos);
			pos_e = input.find_first_of(":", pos_s+1);
			id = atoi(input.substr(pos_s+1, pos_e-pos_s-1).c_str());
			break;
		}
	}
	
	fclose(fp);
	return id;
}

/*
 * get_gid: get group id of a user based on the user's uid
 */
int get_gid(uid_t uid)
{
	char buf[MAXSTRSIZE];
	int id, gid = -1;
	string input;

	FILE *fp;
	if (!(fp = fopen(PASSWDFILE, "r")))
		return -1;

	while (fgets(buf, MAXSTRSIZE, fp)){
		input = buf;
		string::size_type pos = input.find(':');
		string::size_type pos_s, pos_e;
		pos_s = input.find_first_of(":", ++pos);
		pos_e = input.find_first_of(":", pos_s+1);
		id = atoi(input.substr(pos_s+1, pos_e-pos_s-1).c_str());

		pos_s = pos_e + 1;
		pos_e = input.find_first_of(":", pos_s);
		gid = atoi(input.substr(pos_s, pos_e-pos_s).c_str()); 

		if ((uid_t)id == uid)
			break;
	}
	
	fclose(fp);
	return gid;
}

