/***************************************************************************
                          security.h  -  description
                             -------------------
    begin                : Mon Sep 24 2001
    copyright            : (C) 2001 by Yinglian Xie
    email                : ylxie@cs.cmu.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
// security.h: interface for the security library functions
//
//////////////////////////////////////////////////////////////////////

#ifndef SECURITY_H
#define SECURITY_H

#include <string>

using namespace std;

int  read_RSA_key(string& keyfile, string& keystr);
int  write_RSA_key(string& keystr, string& keyfile);
void generate_RSA_key(const char* privFilename, const char* pubFilename);
void RSAEncryptString(string& pubkey, string& cleartext, string& ciphertext);
void RSADecryptString(string& prikey, string& cleartext, string& ciphertext);
void RSASignString(string& prikey, string& messageText, string& signature);
bool RSAVerifyString(string& pubkey, string& messageText, string& signatureText);
void MD5hash(string passwd, string& hashpwd);

#endif /* SECURITY_H */
