/***************************************************************************
                          receiver.h  -  description
                             -------------------
    begin                : Mon Sep 24 2001
    copyright            : (C) 2001 by Yinglian Xie
    email                : ylxie@cs.cmu.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
// receiver.h: interface for the CReceiver class.
//
//////////////////////////////////////////////////////////////////////

#ifndef RECEIVER_H
#define RECEIVER_H

#define SINGLEUSER  0
#define MULTIUSER   1

class CReqQueue;

/*--------- class CReceiver -------------
 */
class CReceiver {
 public:
	int  m_netsd;
	int  m_unixsd;

	CReqQueue  *m_reqQ;	
	
 private:
	short m_minglePort;
	const char* m_unixPath;
	int   m_multiuser;      // whether to work in multi-user mode

 public:
	CReceiver();
	~CReceiver();
	
	/* set up port number based on config options */
	void set_mingle_port(short port);
	void set_mingle_path(const char* path);

	/* set up user mode */
	void set_user_mode(int mode); 

	/* socket listen */
	int net_socket_listen();
	int unix_socket_listen();
	
	/* accept a request */
	int request_accept(int listenfd);
	
	/* read from a socket until not allowed */
	int keep_reading(int sd);
};

#endif // RECEIVER_H
