/***************************************************************************
                          Qprocessor.h  -  description
                             -------------------
    begin                : Tue Sep 18 2001
    copyright            : (C) 2001 by Yinglian Xie
    email                : ylxie@cs.cmu.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
// qprocessor.h: interface for the CQuery, CQprocessor class.
//
//////////////////////////////////////////////////////////////////////

#ifndef QPROCESSOR_H
#define QPROCESSOR_H

#include <time.h>
#include <string>
#include <list>
#include <functional>
#include "findex.h"
#include "utils.h"
using namespace std;

#define OR      0
#define AND     1
#define PHRASE  2

#define SHOW_FIRST 0
#define SHOW_ALL   1

#define DEFAULT_NUMRESULT 10
#define DEFAULT_POSTION CONTENT
#define DEFAULT_SOPTION OR
#define DEFAULT_ROPTION 0
#define DEFAULT_DESCRIPTION SHOW_FIRST


/*--- class CQuery --------------
*/
class CQuery{
public:
	int      m_host;
	string   m_qStr;
	uint     m_qNumResult;
	int      m_qDescription;  // whether find all locations match in a file
	int      m_qPosition;     // whether search at filename or content
	int      m_qRankOption;   // by date, size, frequency
	int      m_qSearchOption; // and, or, phrase
	
public:
	CQuery();
	~CQuery();	
};

/*-----  CQresult --------------
*/
typedef struct{
	int    fNo;
	int    fSize;
	time_t fLmtime;
	string fName;
	string fDescription;
}Qresult;

typedef list<Qresult, allocator<Qresult> > TResultList;

class Qresult_eq: public unary_function<Qresult, int>{
	int n;
 public:
	explicit Qresult_eq(const int& nn): n(nn){}
	int operator() (const Qresult& qr) const{ return qr.fNo == n;}
};

/*--- class CQprocessor --------------
*/
class CQprocessor {

public:
	CFindex *m_index;

 private:
	string m_delimitchar;

public:
	CQprocessor(CFindex *index);
	~CQprocessor();

	void set_delimitchar(string delimitchar);
	void lookup_local(CQuery& q, TResultList& qr, Identity& user);

private:
	void  get_wordlist(string& qstr, TStrList& wlist);
	bool  in_title(string& fname, string& word);
	void  get_description(string& description, int allresults, 
			      string& fname, long location, string& word);
	char* get_next_word(char *buf, int size, char* src);
	int   get_file_info(string& fname, int& fSize, time_t& fLmtime);
};

#endif
