/***************************************************************************
                          mingle.h  -  description
                             -------------------
    begin                : Mon Sep 24 2001
    copyright            : (C) 2001 by Yinglian Xie
    email                : ylxie@cs.cmu.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
// mingle.h: interface for the CMingle class.
//
//////////////////////////////////////////////////////////////////////

#ifndef MINGLE_H
#define MINGLE_H

#include <string>
using namespace std;

#define MAXOPTNUM 23

class CFindex;
class CQprocessor;
class CReceiver;
class CSender;
class CFdManager;
class CReqQueue;
class CUserGroup;
class CMaster;

typedef enum{
	MinglePort = 0, MinglePath, CacheSize, 
		IndexMemory, MaxWordLen, MinWordLen, 
		IndexDir, WordChar, StopWords,
		IsMaster, MasterHost, MasterPort,
		ClusterHosts, SecurityMode, SecurityDir,
		IndexInterval, IndexException, DelimitChar,
		UserMode, PublicKey, PrivateKey,
		PublicTTL, PrivateTTL
}TConfOption;

typedef unsigned char uchar;

class CMingle {
 private:

	// index module 
	CFindex     *m_index;
	
	// query process module
	CQprocessor *m_qprocessor;

	// request process module
	CReqQueue   *m_reqQueue;

	// data send out module
	CSender     *m_sender;
	
	// data receive module
	CReceiver   *m_receiver;

	// file descriptor manager
	CFdManager  *m_fdManager;

	// mingle security manager
	CUserGroup  *m_usergroup;

	// mingle master module
	CMaster     *m_master;
	
	// configuration options
	string m_optvalue[MAXOPTNUM];
	static const string m_optname[MAXOPTNUM];

 public:
	CMingle(const char* name, const char* configFile);
	~CMingle();

	/* main function loop */
	int exec();

	/* regularly update index table */
	void  update_index();

 private:
	/* configure and module init functions */
	int  get_opt_index(string optname);
	void read_config_file(const char* cfname);
	void setup_config();
	void init_config();
	void init_module();
	void mingle_stop();

	/* index interval timer set up */
	void  set_index_interval(int hour);

	/* network set up functions */
	int init_net(char *iface);	
	int get_interfaces(int sockfd, struct ifconf *ifc);
	int get_if_addr(char* iface);
	int get_ip_from_host();	
};

#endif
