/***************************************************************************
                          master.h  -  description
                             -------------------
    begin                : Wed Aug 8 2001
    copyright            : (C) 2001 by Yinglian Xie
    email                : ylxie@cs.cmu.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
// master.h: interface for the CMaster class.
//
//////////////////////////////////////////////////////////////////////

#ifndef MASTER_H
#define MASTER_H

#include <stdio.h>
#include <string>
#include "utils.h"

/*-----signon file-------*/
#define SIGNON_FNAME     ".signon"

/*
 *  type Signon_Record
 */
typedef struct{
	string  mgid;
	string  hashpwd;
	string  pubkey; // file name of the public key
	string  prikey; // file name of the private key
}Signon_Record;

typedef list<Signon_Record, allocator<Signon_Record> > TSignonSet;

/*--------Class Master ------------ 
*/
class CMaster{
 public: 
	// fields valid only if not master server
	uchar     m_ip[HOSTLEN]; // master server ip
	int       m_port;  // master server port number
	string    m_pubkey; // master server public key string
	
	// fields valid only if master server
	THostList m_chosts;   // cluster host list

 private: 
	// fields valid only if master server
 	TSignonSet  m_muser;   
	string      m_signonfile; // file to store signon info
	string      m_signondir;  // dir to store public/private key pairs

 public:
	CMaster();
	~CMaster();

	// set master host if we are not
	void set_master_host(string masterhost, int port); 

	// configure cluster host and signon info if master server
	void setup_cluster(string hostlist); 
	void setup_signon(string dir);
	void setup_pubkey(string pubkey);

	int  register_mid(string newid, string passwd, string& errstr); 
	int  change_passwd(string mgid, string oldpwd, string newpwd);
	int  get_prikey(string mgid, string passwd, string& prikey);
	int  get_pubkey(string mgid, string& pubkey);

	
 private:
	/* security information setup and store */
	void  read_signon();
	void  flush_signon();
};

#endif // MASTER_H
