/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Wed Aug 8 2001
    copyright            : (C) 2001 by Yinglian Xie
    email                : ylxie@cs.cmu.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <signal.h>
#include <sys/time.h>
#include <unistd.h>
#include <string>
#include "mingle.h"
#include "utils.h"

using namespace std;

#define VERSION "0.1"

#ifdef MINGLE_VERBOSE
#define DEBUG_FILE "mingle.debug"
FILE  *errfp;
#endif

// mingle class
CMingle *mingle;

/* sigpipe processing handler */
void sigpipe_handler(int signo);
void timer_handler(int signo);

//////////////////////////////////////////////////////////////////////
//  Implementations
//////////////////////////////////////////////////////////////////////

void sigpipe_handler(int signo)
{
	mingle_debug1("\nSIGPIPLE caught!");
	return;
}

void timer_handler(int signo)
{
	mingle->update_index();
}

void usage()
{
	printf("Mingle server v1.0\n");
	printf("Usage: mingle [-c config file] [-h]\n");
	printf("Options:\n");
	printf("    -c <config file>: use the specified config file\n");
	printf("    -h: Display this help\n");
}

/*
 * main(): main function of mingle server
 */
int main(int argv, char **argc)
{
	string  name;
	int     haveConfig = 0;

	// display help information
	if (argv > 1){
		if (strcmp(argc[1], "-c") == 0){
			if (argv < 3){
				usage();
				return 0;
			}else{
				haveConfig = 1;
			}
		}else{
			usage();
			return 0;
		}
	}

	// randomize random number generator
	srand(rand());
		
	// install our SIGPIPE handler
	if (signal(SIGPIPE, sigpipe_handler) == SIG_ERR){
		printf("ERROR: install SIGPIPE handler error.\n");
	}
	if (signal(SIGALRM, timer_handler) == SIG_ERR){
		printf("ERROR: install SIGALRM handler error.\n");
	}

	
	// if in verbose mode, open debug output file
#ifdef MINGLE_VERBOSE
	errfp = fopen(DEBUG_FILE, "a");
#endif

	// read configuration file
	name = "Mingle server ";
	name += VERSION;
	if (haveConfig)
	    mingle = new CMingle(name.c_str(), argc[2]);
	else
	    mingle = new CMingle(name.c_str(), 0);
	
	// start running now ...
	mingle->exec();

#ifdef MINGLE_VERBOSE
	fclose(errfp);
#endif	

}
