/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Thu Sep 27 21:33:09 EDT 2001
    copyright            : (C) 2001 by Yinglian Xie
    email                : Yinglian.Xie@cs.cmu.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>
#include <sys/un.h>
#include <sys/time.h>
#include <pwd.h>

#include <string>
using namespace std;

#define UNIXSTR_PATH "/tmp/mingle.str"
#define BUFLEN  1024
#ifndef SHUT_WR
#define SHUT_WR 1
#endif

void usage()
{
        printf("Mingle client v1.0\n");
        printf("Usage: mingle cmd [cmd-args] [global-args] [--doc|--help]\n");
	printf("  --help       Print this message.\n");
	printf("  --doc        Print complete Mingle user manual.\n");
	printf("  cmd          Use --help-commands for complete list of commands.\n");
	printf("  cmd-args     Use -H [cmd] for command specific help.\n");
	printf("  global-args  Use --help-options for complete list of arguments.\n");
}


void display_commands()
{
	printf("Mingle commands are:\n");
	printf("\tsignon     Sign on a mingle id at the Mingle cluster master server.\n");
	printf("\tinit       Mingle init to authenticate to the master server.\n");
	printf("\tpasswd     Change Mingle password.\n");
	printf("\tkauthd     Automatically obtain Kerberos ticket every 24 hours.\n");
	printf("\tdisplay    Display Mingle user ID.\n");
	printf("\tindex      Index a file/directory to the index table.\n");
	printf("\tsearch     Search keywords from the index table.\n");
	printf("\taddarp     Add an access-right mapping for a mingle user.\n");
	printf("\trmarp      Remove an access-right mapping for a mingle user.\n");
	printf("\tcleararp   Clear all access-right mappings for a mingle user.\n");
	printf("\tlsarp      List access-right mappings specified.\n"); 
	printf("(Specify the --help option for a list of other help options.)\n");
}

void display_options()
{
        printf("Mingle global opitons are:\n");
        printf("   -r host-list  Send the request to the hosts in the host-list.\n");
        printf("                 where the host-list is of the following format:\n");
        printf("                   all             all the hosts in the Mingle cluster\n");
        printf("                   host1 host2...  where host1, host2 are ip addresses or host names\n");
}

void display_document()
{
	printf("This is the Mingle system documentation.\n");
	printf("\n");
	printf("   Copyright (C) 2002 Carnegie Mellon University\n");
	printf("\n");
	printf("\n");
	printf("...Table of Contents...\n");
	printf("Mingle\n");
	printf("******\n");
	printf("\n");
	printf("   Mingle is a secure distributed search system for personal computing\n");
	printf("environment.\n");
	printf("\n");
	printf("   The first part of this master menu lists the major nodes in this Info\n");
	printf("document. The rest of the menu lists all the lower level nodes in the\n");
	printf("document.\n");
	printf("\n");
	printf("   This is Edition 1.0 of the Mingle manual, updated October 6, 2002\n");
	printf("\n");
	printf("Mingle Introduction\n");
	printf("*******************\n");
	printf("\n");
	printf("   Mingle is a secure distributed search system for personal computing.\n");
	printf("Mingle precomputes an inverted index of local files on each\n");
	printf("participating host. A query can be processed by the local host, or\n");
	printf("routed through the participating hosts using peer-to-peer communication\n");
	printf("to locate all of the desired data.\n");
	printf("\n");
	printf("   Here are some general features of the Mingle system:\n");
	printf("\n");
	printf("Indexing\n");
	printf("--------\n");
	printf("\n");
	printf("   Mingle precomputes an inverted index table of local files on each\n");
	printf("participating host for fast search. Mingle will then update the index\n");
	printf("table regularly.\n");
	printf("\n");
	printf("Searching\n");
	printf("---------\n");
	printf("\n");
	printf("   Mingle supports keyword search at one or more participating Mingle\n");
	printf("hosts. A query can be processed by the local host, or routed through\n");
	printf("remote hosts to locate all of the desired data.\n");
	printf("\n");
	printf("   Advanced search options include:\n");
	printf("\n");
	printf("  1. Search in file names and file contents\n");
	printf("\n");
	printf("  2. Support logic operations \"OR\", \"AND\" in a query\n");
	printf("\n");
	printf("  3. Support wildcard matching (e.g., use \"a*\" as a keyword).\n");
	printf("\n");
	printf("Security\n");
	printf("--------\n");
	printf("\n");
	printf("   Mingle allows file owners to grant search permissions to other Mingle\n");
	printf("users on a file-by-file basis.  Mingle servers authenticate each user\n");
	printf("request to protect data from being accessed by unauthorized users.\n");
	printf("\n");
	printf("Beginning to use Mingle\n");
	printf("***********************\n");
	printf("\n");
	printf("   A Mingle cluster consists of one or more Mingle hosts. On each host,\n");
	printf("there is a Mingle server running as a daemon.  A user may issue a\n");
	printf("request from any host to any of the servers by launching a Mingle client\n");
	printf("program. In many cases, a user may wish to issue request to all hosts in\n");
	printf("a Mingle cluster without specifying host identities. To enable this, you\n");
	printf("will need to configure a master server for each Mingle cluster (*note\n");
	printf("Master server configuration::).\n");
	printf("\n");
	printf("   A Mingle server can work in single user mode or multiple user mode.\n");
	printf("In single user mode, the server will not be used by other local users\n");
	printf("that have accounts on the same computer. While in multiple user mode,\n");
	printf("only one copy of server will be running on a host and the server is\n");
	printf("shared by all the local users (*note User mode set up::).\n");
	printf("\n");
	printf("   Before using Mingle, each user will need to sign on a Mingle ID that\n");
	printf("identifies the user to Mingle servers in a uniform way.  Each Mingle ID\n");
	printf("is globally unique within a Mingle cluster. A Mingle ID is assigned to a\n");
	printf("user via a registration process called Mingle single sign-on (*note\n");
	printf("Mingle single sign-on::).\n");
	printf("\n");
	printf("   If you wish to index files on a host or specify access control\n");
	printf("decisions, a Mingle ID is usually not enough. The corresponding Mingle\n");
	printf("server has to know which local user you are to perform such operations.\n");
	printf("Therefore, you will need to present both your local identity and your\n");
	printf("Mingle ID to the corresponding servers by a process called \"Mingle\n");
	printf("init\", when your local user ID is associated with your Mingle ID (*note\n");
	printf("Mingle init::).\n");
	printf("\n");
	printf("   To protect data from being searched by unauthorized users, a Mingle\n");
	printf("server will authenticate each user request. The local request\n");
	printf("authentication is performed by the operating system when the user logs\n");
	printf("in to the host. The remote request authentication is based on\n");
	printf("conventional digital signature using the RSA algorithms. Each Mingle\n");
	printf("user is associated with a pair of RSA keys (a public RSA key and a\n");
	printf("private RSA key) that are generated by the Master server at single\n");
	printf("sign-on (*note RSA key distribution::).\n");
	printf("\n");
	printf("Master server configuration\n");
	printf("===========================\n");
	printf("\n");
	printf("   Master server is a normal Mingle server that maintains the list of\n");
	printf("host names inside the cluster. Upon reception of a user request that\n");
	printf("needs to be routed through the cluster, a local Mingle server first\n");
	printf("fetches the host list from the master server, and then forwards the\n");
	printf("request to each remote host in the list.\n");
	printf("\n");
	printf("   You can configure the master server by using the \"IsMaster\"\n");
	printf("parameter in the Mingle configure file (A default Mingle configure file\n");
	printf("is contained in the Mingle server package). For example,\n");
	printf("\n");
	printf("     IsMaster = 1\n");
	printf("\n");
	printf("   will set the local Mingle server to be the master server.\n");
	printf("\n");
	printf("   For a master server, Use the parameter \"ClusterHosts\" to specify the\n");
	printf("list of host names (and port numbers) inside the cluster. For example,\n");
	printf("\n");
	printf("     ClusterHost = \"area51\", \"grassyknoll:3000\"\n");
	printf("\n");
	printf("   Note that you must specify all the hosts in one line, separating two\n");
	printf("adjacent hosts by a comma followed by one or more blank spaces.\n");
	printf("\n");
	printf("   For a normal server, use the parameter \"MasterHost\" and \"MasterPort\"\n");
	printf("to specify the master server from which a list of host names can be\n");
	printf("fetched. For example,\n");
	printf("\n");
	printf("     MasterHost = area51\n");
	printf("     MasterPort = 3000\n");
	printf("\n");
	printf("User mode set up\n");
	printf("================\n");
	printf("\n");
	printf("   A Mingle server can run in single user mode or multiple user mode.\n");
	printf("When a server runs in single user mode, only the local user who starts\n");
	printf("the daemon can submit local requests to the server. When running in\n");
	printf("multiple user mode, the server will be shared by multiple local users.\n");
	printf("Use the parameter \"UserMode\" in the configure file to set up user mode.\n");
	printf("\n");
	printf("   For example,\n");
	printf("\n");
	printf("     UserMode = 1\n");
	printf("\n");
	printf("   will allow multiple local users to submit local requests to the\n");
	printf("server. In such case, you usually need to run the server in root mode.\n");
	printf("Note that whether in single user mode or multiple user mode, the server\n");
	printf("will accept remote requests from any user.\n");
	printf("\n");
	printf("Mingle single sign-on\n");
	printf("=====================\n");
	printf("\n");
	printf("   In a Mingle cluster, each user is identified by a global, unique\n");
	printf("Mingle ID. The Mingle ID has to be signed on explicitly once before\n");
	printf("using Mingle. To do this, you will have to log in to one of the Mingle\n");
	printf("host, and submit a sign-on request:\n");
	printf("\n");
	printf("     mingle signon mingle-id\n");
	printf("\n");
	printf("   In the above command, `mingle-id' is a text string that you select.\n");
	printf("You will then be prompted to input a Mingle password to the client\n");
	printf("program, which conveys both the Mingle ID and the password to the local\n");
	printf("Mingle server. The local Mingle server sends this pair to the master\n");
	printf("server for this Mingle cluster. If the Mingle ID has not previously\n");
	printf("been registered, the master server generates an RSA key pair for you,\n");
	printf("which will later be retrieved by the mingle servers in the same cluster\n");
	printf("to authenticate your requests whenever necessary (*note RSA key\n");
	printf("distribution::).\n");
	printf("\n");
	printf("   After signing on, you have established your identity represented as\n");
	printf("your Mingle ID in the cluster. Use the command `mingle passwd' if you\n");
	printf("wish to change your Mingle password:\n");
	printf("\n");
	printf("     mingle passwd mingle-id\n");
	printf("\n");
	printf("Mingle init\n");
	printf("===========\n");
	printf("\n");
	printf("   After Mingle sign-on, you are uniquely identified as your Mingle ID\n");
	printf("in the corresponding cluster.  However, if you wish to index files on a\n");
	printf("host or specify access control decisions, you will need to let the\n");
	printf("corresponding Mingle server know which local user you are via the\n");
	printf("`mingle init' command.  This Mingle init process also presents your\n");
	printf("Mingle ID to the server so that the server can sign the request on your\n");
	printf("behalf before forwarding the request to the remote servers.  Note that\n");
	printf("the `mingle init' request has to be submitted locally, meaning that you\n");
	printf("will need to log in to the desired Mingle host and submit a request\n");
	printf("there.\n");
	printf("\n");
	printf("   The syntax of the `mingle init' request is the following:\n");
	printf("\n");
	printf("     mingle init mingle-id\n");
	printf("\n");
	printf("   where `mingle-id' is the Mingle ID that you have signed on. Next,\n");
	printf("the Mingle server interactively prompts you for your Mingle password for\n");
	printf("authentication, creates an entry for you, and associate your local user\n");
	printf("name and your Mingle ID together so that you no longer need to enter\n");
	printf("your Mingle ID for subsequent requests.  The local Mingle server will\n");
	printf("also fetch your RSA private signing key from the master server using\n");
	printf("your password and cache it (*note RSA key distribution::).\n");
	printf("\n");
	printf("   After the cached private key expires, this Mingle init process can be\n");
	printf("repeated to obtain a refresh copy of key for caching. Therefore, the\n");
	printf("private key cache expiration time determines the frequency of executing\n");
	printf("such \"init\" command. Modify the parameter \"PrivateTTL\" to adjust the\n");
	printf("expiration time of caching private keys.\n");
	printf("\n");
	printf("   After Mingle init, use the command `mingle display' to check your\n");
	printf("current status. For example, if your local user name is `bovik' and\n");
	printf("your Mingle ID is `mbovik', then\n");
	printf("\n");
	printf("     mingle display\n");
	printf("\n");
	printf("   will return\n");
	printf("\n");
	printf("     Mingle ID     = mbovik\n");
	printf("     Local user ID = bovik\n");
	printf("\n");
	printf("RSA key distribution\n");
	printf("====================\n");
	printf("\n");
	printf("   By default, mingle servers authenticate each user request in order to\n");
	printf("protect data from being accessed by unauthorized people. You can enabled\n");
	printf("or disabled the permission checking by modifying the parameter\n");
	printf("\"SecurityMode\" in the Mingle configure file. For example,\n");
	printf("\n");
	printf("     SecurityMode = 0\n");
	printf("\n");
	printf("   disables the permission checking for all user requests.\n");
	printf("\n");
	printf("   When permission checking is enabled, a Mingle server will\n");
	printf("authenticate remote requests using the RSA digital signature scheme.\n");
	printf("\n");
	printf("   Each Mingle user has a pair of RSA signing keys (generated by the\n");
	printf("master server at Mingle single sign-on (*note Mingle single\n");
	printf("sign-on::)). Once a local Mingle server obtains your private RSA key at\n");
	printf("Mingle init (*note Mingle single sign-on::), the server can sign your\n");
	printf("request using your private key, and send the signed request to the\n");
	printf("relevant remote Mingle servers.\n");
	printf("\n");
	printf("   Each remote Mingle server that receives this request will retrieve\n");
	printf("your public key from the master server, and then verify the digital\n");
	printf("signature using it. The public keys can also be cached for better\n");
	printf("performance. Modify the parameter \"PublicTTL\" to adjust the cache\n");
	printf("expiration time for public keys.\n");
	printf("\n");
	printf("   For example,\n");
	printf("\n");
	printf("     PublicTTL = 24\n");
	printf("\n");
	printf("   sets the public key cache expiration time to be 24 hours.\n");
	printf("\n");
	printf("   Both the key distribution and the request authentication processes\n");
	printf("are transparent to the user, so that you do not need to manage your own\n");
	printf("RSA keys. However, each Mingle server also has a pair of RSA keys to\n");
	printf("encrypt and decrypt passwords and private keys to protect them from\n");
	printf("being eavesdropped during transmission.  You can manually specify the\n");
	printf("pair of keys used by a server by modifying the \"PublicKey\" and\n");
	printf("\"PrivateKey\" parameters in the configure file, or let the server create\n");
	printf("and handle them for you.\n");
	printf("\n");
	printf("An example\n");
	printf("==========\n");
	printf("\n");
	printf("   Suppose you wish to set up a Mingle cluster consisting of two hosts:\n");
	printf("`area51.cmcl.cs.cmu.edu' (`area51' in short) and\n");
	printf("`grassynoll.cmcl.cs.cmu.edu' (`grassyknoll' in short). In both hosts,\n");
	printf("there will be one Mingle server running at port number 7018. You would\n");
	printf("like to configure the host `area51' to be the master server. Your local\n");
	printf("user name at host `area51' is `abovik' and your local user name at host\n");
	printf("`grassyknoll' is `gbovik'. Your preferred Mingle ID is `mbovik', and you\n");
	printf("wish to cache RSA keys for one day.\n");
	printf("\n");
	printf("   First, you log in to `area51', and modify the following parameters in\n");
	printf("the configure file:\n");
	printf("\n");
	printf("     MinglePort = 7018\n");
	printf("     IsMaster = 1\n");
	printf("     ClusterHosts = \"LOCAL\", \"grassyknoll\"\n");
	printf("     UserMode = 1\n");
	printf("     PublicTTL = 24\n");
	printf("     PrivateTTL = 24\n");
	printf("\n");
	printf("   Then, start the Mingle server at `area51':\n");
	printf("\n");
	printf("     [abovik@area51]$mingle -c mingle.config &\n");
	printf("     Mingle server 0.1\n");
	printf("     Local ip: 128.2.220.239  local port: 7018\n");
	printf("     Start accepting requests now...\n");
	printf("\n");
	printf("   And perform the Mingle single sign-on and Mingle init:\n");
	printf("\n");
	printf("     [abovik@area51]$mingle signon mbovik\n");
	printf("     Select your Mingle password: ********\n");
	printf("     Reenter password: ********\n");
	printf("     Success: Sign-on successfully.\n");
	printf("\n");
	printf("     [abovik@area51]$mingle init mbovik\n");
	printf("     Please enter your password: ********\n");
	printf("     Success: Mingle init successfully.\n");
	printf("\n");
	printf("     [abovik@area51]$mingle display\n");
	printf("     Mingle ID     = mbovik\n");
	printf("     Local user ID = abovik\n");
	printf("\n");
	printf("   Next, you log in to `grassyknoll', and modify the following\n");
	printf("parameters in the configure file there:\n");
	printf("\n");
	printf("     MinglePort = 7018\n");
	printf("     IsMaster = 0\n");
	printf("     MasterHost = area51\n");
	printf("     UserMode = 1\n");
	printf("     PublicTTL = 24\n");
	printf("     PrivateTTL = 24\n");
	printf("\n");
	printf("   Start the Mingle server at `grassyknoll':\n");
	printf("     [gbovik@grassyknoll]$mingle -c mingle.config &\n");
	printf("     Mingle server 0.1\n");
	printf("     Local ip: 128.2.220.241  local port: 7018\n");
	printf("     Start accepting requests now...\n");
	printf("\n");
	printf("   Finally, perform Mingle init at `grassyknoll':\n");
	printf("\n");
	printf("     [gbovik@grassyknoll]$mingle init mbovik\n");
	printf("     Please enter your password: ********\n");
	printf("     Success: Mingle init successfully.\n");
	printf("\n");
	printf("     [gbovik@grassyknoll]$mingle display\n");
	printf("     Mingle ID     = mbovik\n");
	printf("     Local user ID = gbovik\n");
	printf("\n");
	printf("   From now on, you are done with the initial set up, you can start\n");
	printf("submitting requests from either `area51' or `grassyknoll' as you would\n");
	printf("like.\n");
	printf("\n");
	printf("Sending remote requests\n");
	printf("***********************\n");
	printf("\n");
	printf("   You can send a request from any Mingle host to any remote Mingle\n");
	printf("server using the `-r' option followed by a remote host list:\n");
	printf("\n");
	printf("     mingle command -r host-list\n");
	printf("\n");
	printf("   where the host-list is of the following format:\n");
	printf("\n");
	printf("     host1:port1  host2:port2 ...\n");
	printf("\n");
	printf("   For example,\n");
	printf("\n");
	printf("     mingle search bovik -r area51 grassyknoll:3000\n");
	printf("\n");
	printf("   will forward the request of searching keyword `bovik' to the host\n");
	printf("`area51' at the default Mingle port `7018' and the host `grassyknoll' at\n");
	printf("port `3000'.\n");
	printf("\n");
	printf("   As another example,\n");
	printf("\n");
	printf("     mingle index /home/bovik/test -r area51\n");
	printf("\n");
	printf("   will request the remote host `area51' to index the directory\n");
	printf("`/home/bovik/test' (Note: the `/home/bovik/test' directory should be a\n");
	printf("valid directory at *area51* before indexing).\n");
	printf("\n");
	printf("   If the host-list is specified as `all', then the local Mingle server\n");
	printf("forwards the corresponding request to all the Mingle servers inside the\n");
	printf("Mingle cluster. For example,\n");
	printf("\n");
	printf("     mingle search bovik -r all\n");
	printf("\n");
	printf("Indexing\n");
	printf("********\n");
	printf("\n");
	printf("   When a Mingle server is started on a host for the first time, none of\n");
	printf("the files on that host are indexed. You must make explicit requests to a\n");
	printf("Mingle server to index directory trees or files that you own. Thus\n");
	printf("Mingle is \"opt-in\" in the sense that users on Mingle hosts must issue\n");
	printf("explicit requests before their data is indexed and made available to\n");
	printf("Mingle clients.\n");
	printf("\n");
	printf("   Here is the syntax of an index request:\n");
	printf("\n");
	printf("     mingle index dir1/file1 dir2/file\n");
	printf("\n");
	printf("   A Mingle server stores the computed index table in the local disk.\n");
	printf("You can specify where to store the index table by setting the parameter\n");
	printf("\"IndexDir\" in the Mingle configure file. For performance optimization,\n");
	printf("Mingle maintains a cache in memory for frequently accessed terms and\n");
	printf("their indexes.  Adjust the cache size using the parameter \"CacheSize\".\n");
	printf("\n");
	printf("   Mingle servers will update the index tables regularly. By modifying\n");
	printf("the parameter \"IndexInterval\", you can customize the frequency of such\n");
	printf("updates.\n");
	printf("\n");
	printf("Searching\n");
	printf("*********\n");
	printf("\n");
	printf("   The syntax of a search request is:\n");
	printf("\n");
	printf("     mingle search keywords [-ts] [-a AND|OR] [-n num]\n");
	printf("\n");
	printf("   By default, Mingle performs search in file contents. Use `-t' option\n");
	printf("to search keywords in file names.\n");
	printf("\n");
	printf("   Use a pair of quotation marks \"\" to enclose all the keywords if\n");
	printf("multiple keywords are specified. Mingle also supports wildcard matching\n");
	printf("where you can use a \"*\" to match one or more characters.\n");
	printf("\n");
	printf("   If you use the `-s' option, then Mingle will display all the matching\n");
	printf("results in a file. By default, Mingle only displays the first result in\n");
	printf("each file.\n");
	printf("\n");
	printf("   Use the `-a' option to specify the logic operations among keywords.\n");
	printf("The default logic operation is \"OR\".\n");
	printf("\n");
	printf("   Use the `-n' option to specify the number of results to be\n");
	printf("displayed. By default, the first 10 results are displayed for each\n");
	printf("query.\n");
	printf("\n");
	printf("   For example,\n");
	printf("\n");
	printf("     mingle search \"fit*\"\n");
	printf("\n");
	printf("   will return the first 10 files that contain any word starting with\n");
	printf("prefix \"fit\".  For each file, Mingle displays the first line that a\n");
	printf("keyword appears.\n");
	printf("\n");
	printf("     mingle search \"computer bovik\" -s -a AND -n 5\n");
	printf("\n");
	printf("   will return the first 5 files that contain both the keyword\n");
	printf("`computer' and the keyword `bovik'. For each returned file, Mingle\n");
	printf("displays all the matched lines.\n");
	printf("\n");
	printf("Access control\n");
	printf("**************\n");
	printf("\n");
	printf("   Mingle allows file owners to grant search permissions to other Mingle\n");
	printf("users on a file-by-file basis. You can specify your access control\n");
	printf("decisions using an access-right mapping where you map a Mingle user U\n");
	printf("to a local user name (or group name) U, meaning the Mingle user U is\n");
	printf("able to search all the files that are searchable by the mapped local\n");
	printf("user (or group) U.\n");
	printf("\n");
	printf("   The syntax of an access-right mapping request is the following:\n");
	printf("\n");
	printf("     mingle addarp [-ug] mingle-id user-id (group-id)\n");
	printf("\n");
	printf("   Use the `-u' option if the user identified as `mingle-id' is mapped\n");
	printf("to a local user id `user-id'. Use the `-g' option for a local group id.\n");
	printf("\n");
	printf("   For example,\n");
	printf("\n");
	printf("     mingle addarp -u mbovik bovik\n");
	printf("\n");
	printf("   maps the Mingle user with Mingle ID `mbovik' to a local user name\n");
	printf("`bovik'.\n");
	printf("\n");
	printf("   You can delete an access-right mapping entry by using the command\n");
	printf("`mingle rmarp'. For example,\n");
	printf("\n");
	printf("     mingle rmarp -u mbovik bovik\n");
	printf("\n");
	printf("   You can use the command `mingle cleararp' to delete all access-right\n");
	printf("mappings associated with a specific Mingle user. For example,\n");
	printf("\n");
	printf("     mingle cleararp mbovik\n");
	printf("\n");
	printf("   will delete all access-right mappings created for the Mingle ID\n");
	printf("`mbovik'.\n");
	printf("\n");
	printf("   Use the command `mingle lsarp' to check the current access-right\n");
	printf("mappings. For example,\n");
	printf("\n");
	printf("     mingle lsarp mbovik\n");
	printf("\n");
	printf("   displays all the access-right mappings associated with Mingle ID\n");
	printf("`mbovik'.\n");
	printf("\n");
	printf("     mingle lsarp\n");
	printf("\n");
	printf("   displays the access-right mappings for all the Mingle users that you\n");
	printf("have granted permissions.\n");
	printf("\n");
	printf("Searching AFS files\n");
	printf("*******************\n");
	printf("\n");
	printf("   AFS is a distributed file system that enables sharing files across\n");
	printf("both local area and wide area networks.  It is based on a distributed\n");
	printf("file system that was called the Andrew File System developed at\n");
	printf("Carnegie Mellon University.\n");
	printf("\n");
	printf("   Here are some general features of AFS:\n");
	printf("\n");
	printf("  1. In conjunction with Kerberos, AFS provides a global authentication\n");
	printf("     system (all passwords are verified with a site-wide database).\n");
	printf("\n");
	printf("  2. Access Control Lists (ACLs) provide more flexibility in setting\n");
	printf("     file access permissions than traditional Unix file systems.\n");
	printf("\n");
	printf("  3. Users can access AFS files at remote sites, if given appropriate\n");
	printf("     permissions.\n");
	printf("\n");
	printf("\n");
	printf("   Mingle treats AFS files as normal files on another \"disk\". Current\n");
	printf("implementation supports CMU AFS file system, and may need to be revised\n");
	printf("to port to other AFS file systems.\n");
	printf("\n");
	printf("   AFS related commands include:\n");
	printf("\n");
	printf("  1. *mingle init*\n");
	printf("\n");
	printf("     In order to index and search AFS files, you need to have a valid\n");
	printf("     AFS user ID that are conveyed to Mingle via the Mingle init\n");
	printf("     process using the following syntax:\n");
	printf("\n");
	printf("          mingle init mingle-id -afs afs-id\n");
	printf("\n");
	printf("     For example,\n");
	printf("\n");
	printf("          mingle init mbovik -afs afsbovik\n");
	printf("\n");
	printf("     associates the Mingle ID `mbovik' with the AFS user ID `afsbovik'.\n");
	printf("\n");
	printf("     The init process interactively prompts you for your Mingle\n");
	printf("     password and your AFS password, which it uses to authenticate to\n");
	printf("     the master server and the Kerberos server. It also obtains a\n");
	printf("     Kerberos ticket for the specified AFS user ID so that further\n");
	printf("     operations such as indexing AFS files will be permitted.  However,\n");
	printf("     a Mingle server can hold only one (the latest) AFS user ticket at\n");
	printf("     any time. Therefore, it is a good idea to perform the `mingle\n");
	printf("     init' command every time before indexing AFS directories or files.\n");
	printf("\n");
	printf("  2. *mingle kauthd*\n");
	printf("\n");
	printf("     Since a mingle server can hold only one AFS user ticket and an AFS\n");
	printf("     ticket lasts for only 24 hours, the server may lose your AFS\n");
	printf("     ticket when updating index tables.  You can execute the `mingle\n");
	printf("     init' command periodically, or use the `mingle kauthd' command to\n");
	printf("     let server automatically periodically reauthenticate to Kerberos\n");
	printf("     on your behalf:\n");
	printf("\n");
	printf("          mingle kauthd mingle-id -afs afs-id\n");
	printf("\n");
	printf("     Note that by executing the `mingle kauthd' command, you implicitly\n");
	printf("     allow the Mingle server to remember your AFS password.  However,\n");
	printf("     the server will be careful not to ever write your password to the\n");
	printf("     file system.\n");
	printf("\n");
	printf("  3. *mingle display*\n");
	printf("\n");
	printf("     The `mingle display' command shows your current AFS user ID. For\n");
	printf("     example,\n");
	printf("\n");
	printf("          [abovik@area51]$mingle display\n");
	printf("          Mingle ID     = mbovik\n");
	printf("          Local user ID = gbovik\n");
	printf("          AFS ID        = afsbovik\n");
	printf("\n");
	printf("  4. *mingle addarp/rmarp/lsarp*\n");
	printf("\n");
	printf("     You can use the `-a' option to specify access-right mappings for an\n");
	printf("     AFS user ID. For example,\n");
	printf("\n");
	printf("          mingle addarp -a mfred afsbovik\n");
	printf("\n");
	printf("     maps the Mingle user with Mingle ID `mfred' to AFS user ID\n");
	printf("     `afsbovik'\n");
	printf("\n");
	printf("\n");
	printf("Concept Index\n");
	printf("*************\n");
	printf("\n");
	printf("Access control:\n");
	printf("          See ``Access control''.\n");
	printf("An example:\n");
	printf("          See ``An example''.\n");
	printf("Beginning to use Mingle:\n");
	printf("          See ``Beginning to use Mingle''.\n");
	printf("Indexing:\n");
	printf("          See ``Indexing''.\n");
	printf("Master server configuration:\n");
	printf("          See ``Master server configuration''.\n");
	printf("Mingle init:\n");
	printf("          See ``Mingle init''.\n");
	printf("Mingle Introduction:\n");
	printf("          See ``Mingle Introduction''.\n");
	printf("Mingle single sign-on:\n");
	printf("          See ``Mingle single sign-on''.\n");
	printf("RSA key distribution:\n");
	printf("          See ``RSA key distribution''.\n");
	printf("Searching:\n");
	printf("          See ``Searching''.\n");
	printf("Searching AFS files:\n");
	printf("          See ``Searching AFS files''.\n");
	printf("Sending remote requests:\n");
	printf("          See ``Sending remote requests''.\n");
	printf("User mode set up:\n");
	printf("          See ``User mode set up''.\n");
	printf("\n");
}

void usage_index()
{
	printf("Usage: mingle index dir1/file1 dir2/file2...\n");
}

void usage_search()
{
	printf("Usage: mingle search keywords [-ts] [-a AND|OR] [-n num]\n");
	printf("  -t           Search only in the file names (\n");
	printf("               (by default, search is conducted in the file contents)\n");
	printf("  -s           Display all results matched in a file\n");
	printf("               (by default, only the first matched result is displayed for each file)\n");
	printf("  -a AND|OR    Specify relations among keywords\n");
	printf("               (by default, OR is used)\n");
	printf("  -n num        Display the first num of results\n");
	printf("               (by default, ten results are displayed)\n");
}

void usage_signon()
{
	printf("Usage: mingle signon mingle-id\n");
	printf("    mingle-id   A user selected string that uniquely identify\n");
	printf("                the user in a Mingle cluster\n");
}

void usage_init()
{
	printf("Usage: mingle init mingle-id [-afs afs-id]\n");
	printf("  -afs       Initialize as an afs user too.\n");
}

void usage_kauthd()
{
	printf("Usage: mingle kauthd mingle-id -afs afs-id\n");
}

void usage_passwd()
{
	printf("Usage: mingle passwd mingle-id\n");
}

void usage_display()
{
	printf("Usage: mingle display\n");
}

void usage_addarp()
{ 
	printf("Usage: mingle addarp [-uga] mingle-id mapped-id\n");
	printf("\t-u    mapped-id is a local user id (i.e. user account name)\n");
	printf("\t-g    mapped-id is a local group id\n");
	printf("\t-a    mapped-id is an AFS id\n");
}

void usage_rmarp()
{
	printf("Usage: mingle rmarp [-uga] mingle-id mapped-id\n");
	printf("\t-u    mapped-id is a local user id (i.e. user account name)\n");
	printf("\t-g    mapped-id is a local group id\n");
	printf("\t-a    mapped-id is an AFS group id\n");
}

void usage_cleararp()
{
	printf("Usage: mingle cleararp mingle-id\n");
}

void usage_lsarp()
{
	printf("Usage: mingle lsarp [mingle-id]\n");
	printf("\tmingle-id    Display access-right mappings related to mingle-id\n");
	printf("\t             (by default, display access-right mappings for all the mingle users)\n");
}

void usage_host()
{
	printf("Usage: mingle --host\n");
}


int socket_connect()
{
	int sockfd;
	struct sockaddr_un servaddr;

	// create a socket and then connect to the server
	sockfd = socket(AF_LOCAL, SOCK_STREAM, 0);
	if (sockfd < 0){
		fprintf(stderr,	"Socket create error (%s)\n",
				strerror(errno));
		return -1; 			
	}
	
	bzero(&servaddr, sizeof(servaddr));
	servaddr.sun_family = AF_LOCAL;
	strcpy(servaddr.sun_path, UNIXSTR_PATH);
	
	if (connect(sockfd, (struct sockaddr* )&servaddr, sizeof(servaddr)) == -1){
		fprintf(stderr,
				"Cannot connect to server (%s)\n",
				strerror(errno));
		close(sockfd);
		return -1; 		
	}	
	
	return sockfd;			
}


int main(int argc, char *argv[])
{
	string command;
	char  buf[BUFLEN], passwd1[BUFLEN], passwd2[BUFLEN], passwd3[BUFLEN];
	pid_t mpid;

#ifdef MINGLE_DEBUG
	struct timeval tv_start;
	struct timeval tv_stop;

	gettimeofday(&tv_start, NULL);
	FILE *output = fopen("output", "w");
#endif

	/* display usage information */
	if ((argc <= 1) || (strcmp(argv[1], "--help") == 0) || 
	    (strcmp(argv[1], "-h") == 0)){
		usage();
		return -1;
	}	
	if (strcmp(argv[1], "--doc") == 0){
		display_document();
		return -1;
	}

	if (strcmp(argv[1], "--help-commands") == 0){
		display_commands();
		return -1;
	}
        if (strcmp(argv[1], "--help-options") == 0){
                display_options();
                return -1;
        }
	if (strcmp(argv[1], "-H") == 0){
		if (argc < 3){
			printf("No command specified.\n");
			display_commands();
			return -1;
		}

		if (strcmp(argv[2], "signon") == 0){
			usage_signon();
		}else if (strcmp(argv[2], "init") == 0){
			usage_init();
		}else if (strcmp(argv[2], "passwd") == 0){
			usage_passwd();
		}else if (strcmp(argv[2], "display") == 0){
			usage_display();
		}else if (strcmp(argv[2], "addarp") == 0){
			usage_addarp();
		}else if (strcmp(argv[2], "rmarp") == 0){
			usage_rmarp();
		}else if (strcmp(argv[2], "cleararp") == 0){
			usage_cleararp();
		}else if (strcmp(argv[2], "lsarp") == 0){
			usage_lsarp();
		}else if (strcmp(argv[2], "index") == 0){
			usage_index();
		}else if (strcmp(argv[2], "search") == 0){
			usage_search();
		}else if (strcmp(argv[2], "kauthd") == 0){
			usage_kauthd();
		}else{
			printf("Unknown command: %s\n", argv[2]);
			display_commands();
		}
		return -1;
	}

	/* parse command by options */
	if (strcmp(argv[1], "signon") == 0){
		if ((argc < 3) || (strcmp(argv[2], "") == 0)){
			printf("Error: No valid Mingle ID!\n");
			return -1;
		}
			
		/* do not take all the arguments,
		   this is for robustness */
		for (int i = 1; i < 3; i ++){
			command += argv[i];
			command += " ";
		}	
		
		strcpy(passwd1, getpass("Select your Mingle password: "));
		strcpy(passwd2, getpass("Reenter password: "));
		if (strcmp(passwd1, passwd2) != 0){
			printf("Error: Two passwords do not match!\n");
			return -1;
		}else{
			command += passwd1;
		}

	}else if (strcmp(argv[1], "init") == 0){
		int start = 3;

		if ((argc < 3) || (strcmp(argv[2], "") == 0)){
			printf("Error: No valid Mingle ID!\n");
			return -1;
		}

		/* need to check the fourth argument, so add it later
		   this is for robustness */
		for (int i = 1; i < 3; i ++){
			command += argv[i];
			command += " ";
		}	
		
		if ((argc >= 4) && (strcmp(argv[3], "-afs") == 0)){
			if (argc < 5){
				printf("Error: No valid AFS ID!\n");
				return -1;
			}else{
				command += "-afs ";
				command += argv[4];
				command += " ";
				start = 5;

				strcpy(passwd1, getpass("Enter your Mingle password: "));
				command += passwd1;
				strcpy(passwd2, getpass("Enter your AFS password: "));
				command += " ";
				command += passwd2;
			}
		}else{
			strcpy(passwd1, getpass("Please enter your password: "));
			command += passwd1;
		}

		for (int i = start; i < argc; i ++){
			command += argv[i];
			command += " ";
		}

	}else if (strcmp(argv[1], "kauthd") == 0){

		if (argc < 5){
			printf("Error: Too less arguments!\n");
			return -1;
		}

		for (int i = 1; i < 5; i ++){
			command += argv[i];
			command += " ";
		}	
		
		if (strcmp(argv[3], "-afs") != 0){
			printf("Error: Command parse error!\n");
			return -1;
		}

		strcpy(passwd1, getpass("Enter your AFS password: "));
		command += " ";
		command += passwd1;

	}else if (strcmp(argv[1], "passwd") == 0){
		if ((argc < 3) || (strcmp(argv[2], "") == 0)){
			printf("Error: No valid Mingle ID!\n");
			return -1;
		}
			
		/* do not take all the arguments,
		   this is for robustness */
		for (int i = 1; i < 3; i ++){
			command += argv[i];
			command += " ";
		}	
		
		strcpy(passwd1, getpass("Enter old Mingle password: "));
		strcpy(passwd2, getpass("Enter new Mingle password: "));
		strcpy(passwd3, getpass("Reenter new Mingle password: "));
		if (strcmp(passwd3, passwd2) != 0){
			printf("Error: Two new passwords do not match!\n");
			return -1;
		}else{
			command += passwd1;
			command += " ";
			command += passwd2;
		}

	}else{
		/* get the entire command line */
		for (int i = 1; i < argc; i ++){
			command += argv[i];
			command += " ";
		}	

		if ((strcmp(argv[1], "display") != 0) &&
		    (strcmp(argv[1], "index") != 0) &&
		    (strcmp(argv[1], "search") != 0) &&
		    (strcmp(argv[1], "addarp") != 0) &&
		    (strcmp(argv[1], "rmarp") != 0) &&
		    (strcmp(argv[1], "cleararp") != 0) &&
		    (strcmp(argv[1], "lsarp") != 0)){
			
			printf("Unknown command: %s\n", argv[1]);
			display_commands();
			return -1;
		}
	}
		
	/* start running */
	mpid = getpid();

	int sockfd = socket_connect();
	if (sockfd < 0)
		return -1;
					
	if ((write(sockfd, &mpid, sizeof(pid_t)) < 0) ||
	    (write(sockfd, command.c_str(), command.length() + 1) < 0)){
		printf("Data transder error to the server (%s)\n", strerror(errno));
		close(sockfd);
		return -1;
	}	
	shutdown(sockfd, SHUT_WR);

	int num = read(sockfd, buf, BUFLEN-1);
	while (num > 0){
		buf[num] = '\0';
		printf("%s", buf);
		num = read(sockfd, buf, BUFLEN-1);
	}
	
	if (num == -1){
		printf("Data read error from the server (%s)\n", strerror(errno));
	}
	
	close(sockfd);	
	return EXIT_SUCCESS;
}
