/* word.h */

#ifndef _WORD_H
#define _WORD_H

#include "glo.h"
#include <stdio.h>
#include <time.h>

enum Category {  /* gramatical cathegories */
  NONE, NOUN, VERB, ADJECTIVE, ADVERB, PREPOSITION,
  CONJUNCTION, INTERJECTION, PRONOUN
};

typedef struct entry {      /* main dictionary entry */
  char * word;              /* the word */
  enum Category category;   /* gramatical category */
  char * definition;        /* definition(s) text */
  char * translation;       /* translation text */
} Word;


PUBLIC Word * newword(void);
     /* allocate a new word */

PUBLIC Word * changeword(Word * w, char * s);
     /* change the basic word */

PUBLIC int cmpword(Word * e1, Word * e2);
     /* compares two entry pointers according to their word */

PUBLIC int readword(FILE * fd, Word ** w);
     /* read one entry from the file; if done allocate one struct and
	all arrays and put its addres in w. Return error code */
/* #define OK          0 */
#define INCOMPLETE -1
#define NOCATHEG   -2
#define OUTMEM     -3
#define NOWORD     -4
#define UNKNOWN    -5

PUBLIC Word * printword(FILE * f, Word * crt);
     /* print it, return it */

PUBLIC bool incomplete(Word * e);
     /* YES if entry is incomplete (no transl. or def.) */

PUBLIC bool unknown(Word * e);
     /* YES if entry is unknown (no transl. AND def.) */

PUBLIC Word * killword(Word * e);
     /* free its fields */

PUBLIC Word * blendwords(Word * w1, Word * w2);
     /* mixes the two definitions of a same word */

PUBLIC Word * secondword(Word * w1, Word * w2);
     /* returns second word */

PUBLIC bool illegalword(Word * w);
     /* used for words beginning with non-alphabetic char */

PUBLIC Word * copyword(Word * w);
     /* make a copy of all the fields */

PUBLIC char * getword(Word * w);
     /* get the base word of it */

PUBLIC char * getcathstring(Word * w);
     /* return the category string */

PUBLIC Word * changedefinition(Word * w, char * newdef);
     /* change the definition; copies the string */

PUBLIC Word * changetranslation(Word * w, char * newtransl);
     /* change the translation; copies the string */

PUBLIC char * getdefinition(Word * w);
     /* get it */

PUBLIC char * gettranslation(Word * w);
     /* '' */

#endif

