/* io.c */

#include "glo.h"
#include "io.h"
#include <stdio.h>   /* getchar, fprintf */
#include <string.h>  /* strcmp, strcpy */
#include <stdlib.h>  /* malloc */

PRIVATE char * buf = NULL;  /* read-in buffer */
PRIVATE int buf_size = 0;      /* its size */

PRIVATE const int buf_inc = 25;
   /* the buffer grows this much if out of space */

/****************** functions **************************/

PUBLIC int 
error(char * string)
     /* write an error message and return an error code */
{
  char buf[256];		/* nasty coded constant */
  extern int errno;		/* system error */

  fflush(stdout);
  sprintf(buf, "\n** %s", string);
  if (errno != 0) {
    perror(buf);
    errno = 0;			/* clear error indicator */
  }
  else {
    fprintf(stderr, buf);
    fprintf(stderr, "\n");
  }
  return ERROR;
}

PUBLIC void 
skipto(FILE * fd, char stop)
     /* skip to the next `stop' character but not over eol */
{
  int c;
  while ((c = fgetc(fd)) != stop) {
    if (c == '\n' && stop != '\n') {
      ungetc(c, fd);
      break;
    }
    if (c == EOF) break;
  }
}

PUBLIC char * 
readto(FILE * fd, char stop)
     /* read from that file up to the character stop but not over eol;
	allocate a string for the read data;
	return it.  NULL means no string or error.
	*/
{
  char * ret;
  int i, c;
  char * newbuf;

  while ((c = fgetc(fd)) == ' ');  /* skip the leading spaces */
  i = 0;
  while (1) {
    if (c == EOF) break;
    if (c == stop) break;
    if (c == '\n') {
      ungetc(c, fd);
      break;
    }
    if (i+1 >= buf_size) {
      /* out of buffer space */
      if (buf == NULL)    /* some stupid libraries do not
                             treat NULL arg. to realloc fine */
        newbuf = (char *) malloc(buf_inc);
      else
        newbuf = (char * ) realloc(buf, buf_size + buf_inc);
      if (newbuf == NULL) {
	error("string too long: can't alloc");
	return NULL;
      }
      buf = newbuf;
      buf_size += buf_inc;
    }
    buf[i++] = (char) c;
    c = fgetc(fd);
  }
  if (i == 0) return NULL;
  while (buf[i-1] == ' ' && i > 0) i--;  /* skip the trailing spaces */
  if (i == 0) return NULL;
  buf[i] = '\0';
  ret = (char *) malloc(i+1);
  if (ret == NULL) 
    error("out of space in reading text");
  else 
    strcpy(ret, buf);
  return ret;
}

PUBLIC int 
menu(struct menu * options, int size)
     /* menu for user selection */
{
  int i, ret;
  char * text;

  printf("-------------\n");
  for (i=0; i < size; i++)
    printf("%d. %s\n", options[i].sel, options[i].text);
  printf("------------>");
  text = readto(stdin, '\n');
  if (strlen(text) == 0) return ERROR;
  if (text != NULL) {
    ret = text[0] - '0';
    free(text);
  }
  else ret = ERROR;
  return ret;
}

PRIVATE size_t mystrlen(char * s)
     /* works with NULL too */
{
  if (s == NULL) return 0;
  else return strlen(s);
}

PUBLIC char * 
catenate(char * s1, char * s2)
     /* strcat with malloc; return NULL on error */
{
  char * rez;

  if ((s1 == NULL) && (s2 == NULL)) return NULL;
  rez = malloc(mystrlen(s1) + mystrlen(s2) + 1);
  if (rez == NULL) {
    error("Cannot catenate");
    return rez;
  }
  if (s1 != NULL) 
    strcpy(rez, s1);
  else
    strcpy(rez, "");
  if (s2 != NULL) 
    strcat(rez, s2);
  return rez;
}

PRIVATE bool
regexp(char * s1, int start1, int end1, char * s2, int start2, int end2)
     /* regular expression matcher */
{
  /* test if first null */
  if (end1 == start1) {
    if (end2 == start2) return YES;
    if (s2[start2] == '*') /* a NULL is matched by * */
      return regexp(s1, start1, end1, s2, start2+1, end2);
    else 
      return NO;
  }

  /* test if second null (first isn't) */
  if (start2 == end2) return NO;

  /* test for ? */
  if (s2[start2] == '?') 
    return regexp(s1, start1+1, end1, s2, start2+1, end2);

  /* test for * */
  if (s2[start2] == '*') {
    int i;
    for (i = start1; i <= end1; i++)
      if (regexp(s1, i, end1, s2, start2+1, end2)) return YES;
    return NO;
  }

  if (s1[start1] != s2[start2]) return NO;
  return regexp(s1, start1+1, end1, s2, start2+1, end2);
}

PUBLIC bool
regsame(char * s1, char * s2)
     /* YES if s1 is matched by the regex s2 
	s2 may be NULL (matches anything).
	s1 NULL is matched only by NULL.
	s2 may contain * ? */
{
  if (s2 == NULL) return YES;
  if (s1 == NULL) return NO;
  return regexp(s1, 0, strlen(s1), s2, 0, strlen(s2));
}
