
/* dict.h */

#ifndef _DICT_H
#define _DICT_H

#include "glo.h"
#include "btree.h"
#include "types.h"
#include <stdio.h>

typedef struct {
  Tree root;
  Compare compare;
  Kill kill;
  Read read;
  Write write;
  Itis itis;
  void * first, * last;
  long items;  /* WARNING: this may NOT accurately reflect the # of
		  words inside, as when 2 identical words are found
		  only one is kept but both are recorded.  No
		  efficient solution to this is available, and I won't
		  compromise the whole architecture for the sake of
		  this field I really don't use much */

} Dictionary;

Dictionary * newdictionary(Compare, Kill, Read, Write, Itis);
     /* allocate a new, empty dictionary */

Dictionary * destroydictionary(Dictionary * d);
     /* free it entirely */

void * findentry(Dictionary * d, void * e);
     /* finds an entry in the dictionary (returns pointer to it) */
  
int readdictionary(Dictionary *, char * dictfile, 
			  void * first, void * last);
     /* read in the dictionary; keep only words between first and last */

int savedictionary(Dictionary * d, char * file);
     /* save the new dictionary in the indicated file (NULL for stdout)
	return save status */

long dictionarysize(Dictionary * d);
     /* return the number of words in the dictionary */

void * addentry(Dictionary * d, void * entry);
     /* add a new entry to the dictionary;
        return pointer to it or null */

void * randomentry(Dictionary * d);
     /* pick an entry at random */

#endif

