/* btree.h - binary balanced sort tree */

#ifndef _BTREE_H
#define _BTREE_H

#include "glo.h"
#include "types.h"
#include <stdio.h>

typedef struct treecell {  
  void * entry;
  struct treecell * left, * right;
  int depth;	/* used to be a long, but since the tree is balanced,
		   this is enough */
} * Tree;

PUBLIC Tree newtree(void);
     /* build a new binary tree */

PUBLIC Tree killtree(Tree t, Kill);
     /* release the cell after its sons; return NULL */

PUBLIC void * find(Tree r, void * s, Compare);
     /* look for s */

PUBLIC Tree addcell(Tree r, void * what, Compare, Itis);
     /* add a new cell in the dictionary; return new root */ 

PUBLIC void writetree(Tree r, FILE * f, Write w);
      /* print all the tree data in preorder */

PUBLIC void * randomnodeentry(Tree r);
      /* return a random node entry pointer */

PUBLIC int depth(Tree t);
      /* return its depth */
#endif
