/*
 * native.c --- returns the ext4_flag for a native byte order
 * 
 * Copyright (C) 1996 Theodore Ts'o.
 * 
 * This file may be redistributed under the terms of the GNU Public
 * License.
 */

#include <stdio.h>
#include <linux/ext4_fs.h>

#include "ext4fs.h"

static int i386_byteorder(void)
{
	int one = 1;
	char *cp = (char *) &one;

	return (*cp == 1);
}

int ext4fs_native_flag(void)
{
	if (i386_byteorder())
		return 0;
	return EXT4_FLAG_SWAP_BYTES;
}

	
	
