/* 
 * screen/main.c
 * @(#) screen server main file
 * (c) 1995 by Mihai Budiu
 */

#define __SERVER__

#include "../include/globals.h"
#include "../include/error.h"
#include "../include/operation.h"
#include "../include/message.h"
#include "../include/pid.h"
#include "../include/server.h"
#include "../kernel/params.h"

#define DEBUG_LOCAL 1

PRIVATE struct message msg, reply;
PRIVATE void init_screen(void);
PRIVATE do_thing_t do_show_char;

PRIVATE unsigned char * video_ram;
PRIVATE struct screen_info si;

PUBLIC void Main(void)
{
  int err;
  char answer;

  init_screen();

  for (;;) {
    while ((err = receive(&msg)) != E_OK) 
      tell_ker("Receive error", err, SRV_ERROR);
    answer = ANSWER_EXPECTED(msg.flags);
    switch(msg.OPERATION) {
    case SHOW_CHAR:
      err = do_show_char();
      break;
    default:
      err = E_BADOP;
    }
    if (answer) (void)send_reply(msg.SOURCE.local_pid, msg.MSGID,
				 msg.OPERATION, err, &reply);

  }
}

/**************** screen server implementation **********************/

PRIVATE void init_screen(void)

{
  int err;

  msg.INFOi[0] = SCREEN_DATA;
  err = send_receive(SYS_PID, GET_DATA, &msg);
  if (err != E_OK) tell_ker("error in send_rec", err, SRV_PANIC);
  err = msg.ERROR;
  if (err != E_OK) tell_ker("can't get screen data", err, SRV_PANIC);
  video_ram = (unsigned char *)msg.INFOl[0];
  si = *(struct screen_info *)&msg.INFOl[1];
}

PRIVATE int do_show_char(void)

{
  return E_OK;
}
