/* 
 * mm/main.c
 * @(#) Memory manager main file
 * (c) 1995 by Mihai Budiu
 */

#define __SERVER__

#include "../include/globals.h"
#include "../include/operation.h"
#include "../include/message.h"
#include "../include/pid.h"
#include "../include/error.h"
#include "../include/config.h"
#include "../include/server.h"

#define DEBUG_LOCAL 1

PRIVATE struct message msg, reply;
PRIVATE void init_mm(void);

PUBLIC void Main(void)
{
  int err;
  char answer;
  
  init_mm();  /* initializing */

  for (;;) {
    while ((err = receive(&msg)) != E_OK) /* retry */ ;
    answer = ANSWER_EXPECTED(msg.flags);
    switch(msg.OPERATION) {
    default:
       err = E_BADOP;
    }
    if (answer) (void)send_reply(msg.SOURCE.local_pid, msg.MSGID,
				 msg.OPERATION, err, &reply);
  }
}

/**************** memory manager implementation ***********************/

PRIVATE void init_mm(void)

{
}

